# Appendix F: Conversion from FHIR Core STU3 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* **Appendix F: Conversion from FHIR Core STU3**

## Appendix F: Conversion from FHIR Core STU3

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

### Mapping from the FHIR Core STU3 Genomics Profiles

The content in this implementation guide supersedes the genomics profiles that were published as part of FHIR releases STU3 and R4 (which can be found [here](https://hl7.org/fhir/stu3/genomics.html) and [here](http://hl7.org/fhir/R4/genomics.html)). This page provides guidance for implementers of those profiles to understand how to map content from those older profiles to those provided in this implementation guide.

### Why new profiles

As mentioned in the [principles](index.md#principles) section of the introduction, this implementation guide tries to leverage the Observation resource and minimize the use of extensions. This approach is expected to maximize the number of systems that can capture, store, convey and otherwise manipulate genomic reporting results. Over-reliance on extensions increases the risk of information loss, particularly as results pass through systems that may not have been specifically designed to convey genomics-related information. As a [Standard for Trial Use](http://hl7.org/fhir/R5/versions.html#std-process), both the prior profiles and the contents of this implementation guide are subject to non-backward compatible change based on feedback from the implementation community and the continuing evolution of the authoring work group's understanding of implementer requirements and how best to express them within FHIR's data structures.

### Observation-genetics

The Observation-genetics profiles in [STU3](https://hl7.org/fhir/stu3/genomics.html#observation-genetics) and [R4](https://hl7.org/fhir/R4/genomics.html#observation-genetics) largely map to [Variant](StructureDefinition-variant.md), though some more complex annotations are handled as separate "Implications" (see [Diagnostic Implication](StructureDefinition-diagnostic-implication.md) and [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)). Previous extensions are mostly handled as Observation components.

### Sequence -> MolecularSequence Resource

The FHIR STU3 [Sequence](https://hl7.org/fhir/stu3/sequence.html) Resource was renamed to [MolecularSequence](http://hl7.org/fhir/R5/molecularsequence.html) in R4 and has various improvements. The community is still evaluating boundaries between MolecularSequence and Observation and encourages adopter feedback.

FHIR STU3 moved beyond the FHIR DSTU2 Genetics profile on Observation allowing increased granularity and less ambiguity by creating a new resource called MolecularSequence. This resource can be used to hold clinically relevant sequence data in a manner that is both efficient and versatile integrating new and yet undefined types of genomic and other -omics data that will soon be commonly entered into health records for clinical use. MolecularSequence is leveraged by other FHIR resources, including Observation. The September 2014 Informative Ballot ("HL7 Clinical Genomics, Domain Analysis Model: Clinical Sequencing Release 1") provided guiding use cases, which initially informed development of a MolecularSequence resource. A preliminary effort to address these issues was published in context of the Substitutable Medical Applications and Reusable Technologies (SMART) Platforms Project and described in an article ("SMART on FHIR Genomics: Facilitating standardized clinico-genomic apps"). MolecularSequence is designed to hold genetic sequences in blocks relevant to actionable clinical decision-making. Extensions to MolecularSequence can address complex use cases.

