# Artifact List - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* **Artifact List**

## Artifact List

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Abstract Profiles

These are profiles on resources or data types that describe patterns used by other profiles, but cannot be instantiated directly. I.e. instances can conform to profiles based on these abstract profiles but do not declare conformance to the abstract profiles themselves.

| | | | |
| :--- | :--- | :--- | :--- |
| [Genomic Base](StructureDefinition-genomic-base.md) | [Observation](http://hl7.org/fhir/R5/observation.html) | Observation | Base profile that defines characteristics shared by all genetic observations. |
| [Genomic Finding](StructureDefinition-finding.md) | [GenomicBase](StructureDefinition-genomic-base.md) | Observation | Properties common to genetic findings whose results are expressed as computable discrete elements (e.g. genotypes, haplotypes, variants, etc.). |
| [Genomic Implication](StructureDefinition-implication.md) | [GenomicBase](StructureDefinition-genomic-base.md) | Observation | Properties common to genomic implications expressed as computable discrete elements. |

### Resource Profiles

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | | | |
| :--- | :--- | :--- | :--- |
| [Diagnostic Implication](StructureDefinition-diagnostic-implication.md) | [GenomicImplication](StructureDefinition-implication.md) | Observation | Observation stating a diagnostic annotation (e.g. disease risk) on one or more genotype/haplotype/variant/biomarker observations. |
| [Followup Recommendation](StructureDefinition-followup-recommendation.md) | [Task](http://hl7.org/fhir/R5/task.html) | Task | Task proposing a follow-up that is recommended based on the implications of genomic findings. |
| [Genomic Annotation](StructureDefinition-genomic-annotation.md) | [GenomicImplication](StructureDefinition-implication.md) | Observation | Profile for communicating miscellaneous genomic annotations that are neither Diagnostic Implications, Therapeutic Implications, nor Molecular Consequences. |
| [Genomic Data File](StructureDefinition-genomic-data-file.md) | [DocumentReference](http://hl7.org/fhir/R5/documentreference.html) | DocumentReference | A profile of DocumentReference used to represent a genomics file. |
| [Genomic Report](StructureDefinition-genomic-report.md) | [DiagnosticReport](http://hl7.org/fhir/R5/diagnosticreport.html) | DiagnosticReport | Genomic profile of DiagnosticReport. |
| [Genotype](StructureDefinition-genotype.md) | [GenomicFinding](StructureDefinition-finding.md) | Observation | Assertion of a particular genotype on the basis of one or more variants or haplotypes. |
| [Haplotype](StructureDefinition-haplotype.md) | [GenomicFinding](StructureDefinition-finding.md) | Observation | Assertion of a particular haplotype on the basis of one or more variants. |
| [Medication Recommendation](StructureDefinition-medication-recommendation.md) | [Task](http://hl7.org/fhir/R5/task.html) | Task | Task proposing medication recommendations based on the implications of genomic findings. |
| [Molecular Biomarker](StructureDefinition-molecular-biomarker.md) | [Observation](http://hl7.org/fhir/R5/observation.html) | Observation | This profile is used to represent laboratory measurements of human inherent substances such as gene products, antigens and antibodies, and complex chemicals that result from post-translational processing of multi-gene products. |
| [Molecular Consequence](StructureDefinition-molecular-consequence.md) | [GenomicImplication](StructureDefinition-implication.md) | Observation | Profile for communicating the calculated or observed effect of a DNA variant, generally on its downstream transcript and, if applicable, ensuing protein sequence. Molecular consequences may also apply to DNA, such as intergenic regions where there are no transcripts (e.g. 'regulatory_region_variant'). Component 'feature-consequence' categorizes the structural implications of a variant (e.g. the variant disrupts a regulatory region, the variant is an inframe insertion), whereas component 'functional-effect' categorizes how the variant affects overall function (e.g. is predicted to result in loss of gene function). |
| [Sequence Phase Relationship](StructureDefinition-sequence-phase-relationship.md) | [GenomicFinding](StructureDefinition-finding.md) | Observation | Indicates whether two entities are in Cis (same strand) or Trans (opposite strand) relationship to each other. |
| [Therapeutic Implication](StructureDefinition-therapeutic-implication.md) | [GenomicImplication](StructureDefinition-implication.md) | Observation | Observation stating a therapeutic annotation (e.g. drug susceptibility, clinical trial eligibility) on one or more genotype/haplotype/variant/biomarker observations. |
| [Variant](StructureDefinition-variant.md) | [GenomicFinding](StructureDefinition-finding.md) | Observation | Details about a set of changes in the tested sample compared to a reference sequence. |

### Data Type Profiles

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | | |
| :--- | :--- | :--- |
| [Coded Annotation](StructureDefinition-coded-annotation.md) | [Annotation](http://hl7.org/fhir/R5/datatypes.html#Annotation) | Annotation DataType with added CodeableConcept extension element |

### Extension Profiles

These define constraints on FHIR extensions for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Annotation Code](StructureDefinition-annotation-code.md) | Codifies the content of an Annotation |
| [Genomic Report Note](StructureDefinition-genomic-report-note.md) | Adds codified notes to a report to capture additional content |
| [Genomic Risk Assessment](StructureDefinition-genomic-risk-assessment.md) | RiskAssessment delivered as part of a genomics report or observation |
| [KnowledgebaseAncestryGroup](StructureDefinition-knowledgebase-ancestry-group.md) | Used to identify the sample ancestry group using terms obtained from the knowledgebase |
| [Medication Assessed reference to a FHIR resource](StructureDefinition-medication-assessed-reference.md) | Used to reference a specific medication that was assessed (e.g. a FHIR Medication or a FHIR MedicationKnowledge). |
| [Recommended Action](StructureDefinition-recommended-action.md) | References a proposed action that is recommended based on the results of the diagnostic report. |
| [Repeat Motif Order](StructureDefinition-repeat-motif-order.md) | Use to group and order repeat expansion motifs. |
| [Therapy Assessed reference to a FHIR resource](StructureDefinition-therapy-assessed-reference.md) | Used to reference a specific therapy that was assessed (e.g. a FHIR ResearchStudy, a FHIR CarePlan, or a FHIR PlanDefinition). |

### Code Systems

These define code systems that are used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [ClinVar Evidence Level Example Codes](CodeSystem-clinvar-evidence-level-custom-cs.md) | ClinVar contains examples of evidence level concepts that are not conflated with clinical significance. These can be found on ClinVar https://www.ncbi.nlm.nih.gov/clinvar/docs/review_status/ . These examples are informational only, for copyright information contact the relevant source. |
| [Coded Annotation Type Codes](CodeSystem-coded-annotation-types-cs.md) | Code System for specific types of coded annotations |
| [Knowledge Base Codes](CodeSystem-knowledge-base-cs.md) | This example code systems provides examples on how to properly display the knowledge base version number. Version numbers should always be followed by the letter v and calendar dates are displayed Month Day Year. For clarity the month SHALL be written in full. |
| [Molecular Biomarker Ontology Codes](CodeSystem-molecular-biomarker-ontology-cs.md) | This (experimental) code system provides for a draft categorization of biomarkers along several axes. Based on ballot feedback, the committee anticipates significant revisions. |
| [PharmGKB Evidence Level Example Codes](CodeSystem-pharmgkb-evidence-level-custom-cs.md) | PharmGKB contains examples of evidence level concepts that are not conflated with clinical significance. These can be found on PharmGKB https://www.pharmgkb.org/page/clinAnnLevels. These examples are informational only, for copyright information contact the relevant source. |
| [Sequence Phase Relationship Codes](CodeSystem-sequence-phase-relationship-cs.md) | Code System for specific types of relationships |
| [To Be Determined Codes](CodeSystem-tbd-codes-cs.md) | These codes are 'TBD' codes, meaning they are important concepts but codes have not been identifed in available code systems. The CG WG anticpates these codes maturing over time. We may remove some codes as we refine the concepts, or identify suitable replacement codes from other code systems. As we approach normative and these concepts are validated, for codes that remain, we plan to request formal LOINC codes to replace these temporary codes. |
| [Variant Confidence Status Codes](CodeSystem-variant-confidence-status-cs.md) | A code that represents the confidence of a true positive variant call. |

### Value Sets

These define value sets that are used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Coded Annotation Types](ValueSet-coded-annotation-types-vs.md) | Value Set for specific types of coded annotations |
| [Condition Inheritance Patterns](ValueSet-condition-inheritance-mode-vs.md) | Value Set for specific transmission patterns of a condition in a pedigree |
| [DNA Change Type](ValueSet-dna-change-type-vs.md) | DNA Change Type of a variant. |
| [Evidence Level Examples](ValueSet-evidence-level-example-vs.md) | Example sources of values for Evidence Level |
| [Functional Effect Value Set](ValueSet-functional-effect-vs.md) | The effect of a variant on downstream biological products or pathways. |
| [Genetic Therapeutic Implications](ValueSet-genetic-therapeutic-implications-vs.md) | Value Set for terms that describe a predicted ramification based on the presence of associated molecular finding(s). |
| [HUGO Gene Nomenclature Committee Gene Names (HGNC)](ValueSet-hgnc-vs.md) | This value set includes all HGNC Codes, which includes multiple code systems. In this guide, Gene IDs from HGNC are used as CodeableConcepts, which must be sent with the HGNC gene ID including the prefix 'HGNC:' as the code and the HGNC 'gene symbol' as display. CAUTION: HGNC also indexes gene groups by numeric ID (without a prefix), and older systems may send HGNC gene IDs without the prefix, so care must be taken to confirm alignment. We have separately included the genegroup code system to draw attention to this ambiguity and potential error. |
| [Human Genome Variation Society (HGVS) Nomenclature](ValueSet-hgvs-vs.md) | HGVS-nomenclature is used to report and exchange information regarding variants found in DNA, RNA and protein sequences and serves as an international standard. (source: varnomen.hgvs.org) |
| [Knowledge Base Version Codes](ValueSet-knowledge-base-version-vs.md) | Value set for example terms to display the knowledge base version used to calculate and/or obtain data |
| [Molecular Biomarker Categories](ValueSet-molecular-biomarker-category-vs.md) | This value set is drawn from the Molecular Biomarker Ontology code system, which provides codes that characterize a molecular biomarker. |
| [Molecular Biomarker Codes](ValueSet-molecular-biomarker-code-vs.md) | Value Set for terms that can be used as Biomarkers. |
| [Molecular Consequence Value Set](ValueSet-molecular-consequence-vs.md) | The calculated or observed effect of a variant on its downstream transcript and, if applicable, ensuing protein sequence. |
| [Sequence Phase Relationships](ValueSet-sequence-phase-relationship-vs.md) | Value Set for specific types of relationships |
| [To Be Determined Value Set](ValueSet-tbd-codes-vs.md) | Value Set for codes yet to be defined in LOINC |
| [Variant Confidence Status](ValueSet-variant-confidence-status-vs.md) | A code that classifies the confidence for calling this variant. |

### Concept Maps

These define mappings between code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [DNA Change Type Map](ConceptMap-dna-change-type-map.md) | LOINC and SequenceOntology mappings for DNA change type |

### Operation Definitions

These define operations that are used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Find Population Diagnostic Implications](OperationDefinition-find-population-dx-implications.md) | Retrieve count or list of patients having diagnostic implications. |
| [Find Population Molecular Consequences](OperationDefinition-find-population-molecular-consequences.md) | Retrieve count or list of patients having molecular consequences. |
| [Find Population Specific Haplotypes](OperationDefinition-find-population-specific-haplotypes.md) | Retrieve count or list of patients having specified genotypes/haplotypes. |
| [Find Population Specific Variants](OperationDefinition-find-population-specific-variants.md) | Retrieve count or list of patients having specified variants. |
| [Find Population Structural Intersecting Variants](OperationDefinition-find-population-structural-intersecting-variants.md) | Retrieve count or list of patients having structural intersecting variants in specified regions. |
| [Find Population Structural Subsuming Variants](OperationDefinition-find-population-structural-subsuming-variants.md) | Retrieve count or list of patients having structural subsuming variants in specified regions. |
| [Find Population Treatment Implications](OperationDefinition-find-population-tx-implications.md) | Retrieve count or list of patients having therapeutic implications. |
| [Find Study Metadata](OperationDefinition-find-study-metadata.md) | Retrieve metadata about sequencing studies performed on a subject. |
| [Find Subject Diagnostic Implications](OperationDefinition-find-subject-dx-implications.md) | Retrieves genetic diagnostic implications for variants. |
| [Find Subject Haplotypes](OperationDefinition-find-subject-haplotypes.md) | Retrieve haplotypes/genotypes for specified genes. |
| [Find Subject Molecular Consequences](OperationDefinition-find-subject-molecular-consequences.md) | Retrieves molecular consequences of a DNA variant. |
| [Find Subject Specific Haplotypes](OperationDefinition-find-subject-specific-haplotypes.md) | See if specified haplotypes/genotypes are present. |
| [Find Subject Specific Variants](OperationDefinition-find-subject-specific-variants.md) | Determine if specified simple variants are present. |
| [Find Subject Structural Intersecting Variants](OperationDefinition-find-subject-structural-intersecting-variants.md) | Determine if structural variants are present that overlap range(s). |
| [Find Subject Structural Subsuming Variants](OperationDefinition-find-subject-structural-subsuming-variants.md) | Determine if structural variants are present that fully subsume a range. |
| [Find Subject Treatment Implications](OperationDefinition-find-subject-tx-implications.md) | Retrieves genetic therapeutic implications for variants/haplotypes/genotypes. |
| [Find Subject Variants](OperationDefinition-find-subject-variants.md) | Determine if simple variants are present that overlap range(s). |

### Parameters

These define example parameters for operations used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [FindALLPopulationSpecificVariantsOutput](Parameters-FindALLPopulationSpecificVariantsOutput.md) | Example Output of 'FindPopulationSpecificVariants' Operation, based on 'AND' logic |
| [FindANYPopulationSpecificVariantsOutput](Parameters-FindANYPopulationSpecificVariantsOutput.md) | Example Output of 'FindPopulationSpecificVariants' Operation, based on 'OR' logic |
| [FindPopulationDxImplicationsOutput](Parameters-FindPopulationDxImplicationsOutput.md) | Example Output of 'FindPopulationDxImplications' Operation |
| [FindPopulationMolecConseqOutput](Parameters-FindPopulationMolecConseqOutput.md) | Example Output of 'FindPopulationMolecConseq' Operation |
| [FindPopulationSpecificHaplotypesOutput](Parameters-FindPopulationSpecificHaplotypesOutput.md) | Example Output of 'FindPopulationSpecificHaplotypes' Operation |
| [FindPopulationStructuralIntersectingVariantsOutput](Parameters-FindPopulationStructuralIntersectingVariantsOutput.md) | Example Output of 'FindPopulationStructuralIntersectingVariants' Operation |
| [FindPopulationStructuralSubsumingVariantsOutput](Parameters-FindPopulationStructuralSubsumingVariantsOutput.md) | Example Output of 'FindPopulationStructuralSubsumingVariants' Operation |
| [FindPopulationTxImplicationsOutput](Parameters-FindPopulationTxImplicationsOutput.md) | Example Output of 'FindPopulationTxImplications' Operation |
| [FindStudyMetadataOutput](Parameters-FindStudyMetadataOutput.md) | Example Output of 'FindStudyMetadata' Operation |
| [FindSubjectDxImplicationsOutput](Parameters-FindSubjectDxImplicationsOutput.md) | Example Output of 'FindSubjectDxImplications' Operation |
| [FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md) | Example Output of 'FindSubjectHaplotypes' Operation |
| [FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md) | Example Output of 'FindSubjectMolecConseq' Operation |
| [FindSubjectSpecificHaplotypesOutput](Parameters-FindSubjectSpecificHaplotypesOutput.md) | Example Output of 'FindSubjectSpecificHaplotypes' Operation |
| [FindSubjectSpecificVariantsOutput](Parameters-FindSubjectSpecificVariantsOutput.md) | Example Output of 'FindSubjectSpecificVariants' Operation |
| [FindSubjectStructuralIntersectingVariantsOutput](Parameters-FindSubjectStructuralIntersectingVariantsOutput.md) | Example Output of 'FindSubjectStructuralIntersectingVariants' Operation |
| [FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md) | Example Output of 'FindSubjectStructuralSubsumingVariants' Operation |
| [FindSubjectTxImplicationsOutput](Parameters-FindSubjectTxImplicationsOutput.md) | Example Output of 'FindSubjectTxImplications' Operation |
| [FindSubjectVariantsOutput](Parameters-FindSubjectVariantsOutput.md) | Example Output of 'Find Subject Variants' Operation |

### Example Instances

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | | | |
| :--- | :--- | :--- | :--- |
| [AnnotationExample](Observation-AnnotationExample.md) | Observation | Diagnostic Implication | Example of a Diagnostic Implication for Familial hypercholesterolemia |
| [ATR-insertion-molc](Observation-ATR-insertion-molc.md) | Observation | Molecular Consequence | Example Molecular Consequence ATR frameshift |
| [ATR-insertion-significance](Observation-ATR-insertion-significance.md) | Observation | Diagnostic Implication | Example DiagnosticImplication - ATR likely pathogenic |
| [ATR-insertion-var](Observation-ATR-insertion-var.md) | Observation | Variant | Example for ATR insertion |
| [bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md) | Bundle |  | Example of a HLA bundle |
| [bundle-cgexample](Bundle-bundle-cgexample.md) | Bundle |  | Example bundle showing a variety of profiles. |
| [bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md) | Bundle |  | Example bundle showing a variety of profiles, including how groupings of Observations might be delivered. |
| [bundle-complexVariant-nonHGVS](Bundle-bundle-complexVariant-nonHGVS.md) | Bundle |  | Example bundle with compound heterozygous variant, where the specific changes are represented without HGVS. |
| [bundle-compound-heterozygote](Bundle-bundle-compound-heterozygote.md) | Bundle |  | Example bundle with compound heterozygous variant, where the specific changes are represented with HGVS. |
| [bundle-CYP2C19](Bundle-bundle-CYP2C19.md) | Bundle |  | Example bundle containing CYP2C19 report and variants |
| [bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md) | Bundle |  | Example of an oncology report, TMB, variants, and implications. |
| [bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md) | Bundle |  | Example oncology bundle including report, variants, and other resources. |
| [bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md) | Bundle |  | Example bundle with an oncology report with SNVs, TMB, MSI, and therapy matches. |
| [bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md) | Bundle |  | Example bundle with an oncology report with SNVs, TMB, MSI, and therapy matches, including some groupings of observations |
| [bundle-pgxexample](Bundle-bundle-pgxexample.md) | Bundle |  | Example bundle with a PGx report and a variety of observations. |
| [bundle-sequence-phase-relation-CYP2C19](Bundle-bundle-sequence-phase-relation-CYP2C19.md) | Bundle |  | Example Sequence Phase Relation showing a report with two variants in cis |
| [CGPatientExample01](Patient-CGPatientExample01.md) | Patient |  | Example for Patient. Supports references to subject for multiple genomics reporting profile conforming instances. |
| [CNVAnalysis-called](DocumentReference-CNVAnalysis-called.md) | DocumentReference | Genomic Data File | CNVAnalysis_called: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline. |
| [denovoChild](Patient-denovoChild.md) | Patient |  | Child of a trio |
| [denovoFather](Patient-denovoFather.md) | Patient |  | Father of a trio |
| [denovoMother](Patient-denovoMother.md) | Patient |  | Mother of a trio |
| [diagnosticImplication-interact-smn1-smn2](Observation-diagnosticImplication-interact-smn1-smn2.md) | Observation | Diagnostic Implication | Diagnostic Implication for SMN1/SMN2 CNV example |
| [diagnosticreport-hla-glstring-r4](DiagnosticReport-diagnosticreport-hla-glstring-r4.md) | DiagnosticReport | Genomic Report | Example GenomicReport including an HLA glstring |
| [EGFR-L858R-molc](Observation-EGFR-L858R-molc.md) | Observation | Molecular Consequence | Example Molecular Consequence EGFR L858R missense_variant |
| [EGFR-L858R-significance](Observation-EGFR-L858R-significance.md) | Observation | Diagnostic Implication | Example DiagnosticImplication - EGFR pathogenic |
| [EGFR-L858R-therapuDrug1](Observation-EGFR-L858R-therapuDrug1.md) | Observation | Therapeutic Implication | Example of EGFR-L858R Therapeutic Implication for drug treatment 1 |
| [EGFR-L858R-therapuDrug2](Observation-EGFR-L858R-therapuDrug2.md) | Observation | Therapeutic Implication | Example of EGFR-L858R Therapeutic Implication for drug treatment 2 |
| [EGFR-L858R-var](Observation-EGFR-L858R-var.md) | Observation | Variant | Example for EGFR L858R |
| [eMERGEServiceRequest](ServiceRequest-eMERGEServiceRequest.md) | ServiceRequest |  | Example PGx Service Request |
| [ExampleGermlineCNV](Observation-ExampleGermlineCNV.md) | Observation | Variant | Example for germline CNV |
| [ExampleGermlineDEL](Observation-ExampleGermlineDEL.md) | Observation | Variant | Example for germline DEL |
| [ExampleGermlineINV](Observation-ExampleGermlineINV.md) | Observation | Variant | Example for germline INV |
| [ExampleLab](Organization-ExampleLab.md) | Organization |  | Organization (lab) example |
| [ExampleOrg](Organization-ExampleOrg.md) | Organization |  | Example Org |
| [ExamplePatient](Patient-ExamplePatient.md) | Patient |  | Patient example |
| [ExampleServiceRequest](ServiceRequest-ExampleServiceRequest.md) | ServiceRequest |  | ServiceRequest (order) example |
| [ExampleSomaticCNV](Observation-ExampleSomaticCNV.md) | Observation | Variant | Example for somatic CNV |
| [ExampleSomaticDEL](Observation-ExampleSomaticDEL.md) | Observation | Variant | Example for somatic DEL |
| [ExampleSomaticINV](Observation-ExampleSomaticINV.md) | Observation | Variant | Example for somatic INV |
| [ExampleSpecimen](Specimen-ExampleSpecimen.md) | Specimen |  | Specimen example |
| [FindALLPopulationSpecificVariantsOutput](Parameters-FindALLPopulationSpecificVariantsOutput.md) | Parameters |  | Example Output of 'FindPopulationSpecificVariants' Operation, based on 'AND' logic |
| [FindANYPopulationSpecificVariantsOutput](Parameters-FindANYPopulationSpecificVariantsOutput.md) | Parameters |  | Example Output of 'FindPopulationSpecificVariants' Operation, based on 'OR' logic |
| [FindPopulationDxImplicationsOutput](Parameters-FindPopulationDxImplicationsOutput.md) | Parameters |  | Example Output of 'FindPopulationDxImplications' Operation |
| [FindPopulationMolecConseqOutput](Parameters-FindPopulationMolecConseqOutput.md) | Parameters |  | Example Output of 'FindPopulationMolecConseq' Operation |
| [FindPopulationSpecificHaplotypesOutput](Parameters-FindPopulationSpecificHaplotypesOutput.md) | Parameters |  | Example Output of 'FindPopulationSpecificHaplotypes' Operation |
| [FindPopulationStructuralIntersectingVariantsOutput](Parameters-FindPopulationStructuralIntersectingVariantsOutput.md) | Parameters |  | Example Output of 'FindPopulationStructuralIntersectingVariants' Operation |
| [FindPopulationStructuralSubsumingVariantsOutput](Parameters-FindPopulationStructuralSubsumingVariantsOutput.md) | Parameters |  | Example Output of 'FindPopulationStructuralSubsumingVariants' Operation |
| [FindPopulationTxImplicationsOutput](Parameters-FindPopulationTxImplicationsOutput.md) | Parameters |  | Example Output of 'FindPopulationTxImplications' Operation |
| [FindStudyMetadataOutput](Parameters-FindStudyMetadataOutput.md) | Parameters |  | Example Output of 'FindStudyMetadata' Operation |
| [FindSubjectDxImplicationsOutput](Parameters-FindSubjectDxImplicationsOutput.md) | Parameters |  | Example Output of 'FindSubjectDxImplications' Operation |
| [FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md) | Parameters |  | Example Output of 'FindSubjectHaplotypes' Operation |
| [FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md) | Parameters |  | Example Output of 'FindSubjectMolecConseq' Operation |
| [FindSubjectSpecificHaplotypesOutput](Parameters-FindSubjectSpecificHaplotypesOutput.md) | Parameters |  | Example Output of 'FindSubjectSpecificHaplotypes' Operation |
| [FindSubjectSpecificVariantsOutput](Parameters-FindSubjectSpecificVariantsOutput.md) | Parameters |  | Example Output of 'FindSubjectSpecificVariants' Operation |
| [FindSubjectStructuralIntersectingVariantsOutput](Parameters-FindSubjectStructuralIntersectingVariantsOutput.md) | Parameters |  | Example Output of 'FindSubjectStructuralIntersectingVariants' Operation |
| [FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md) | Parameters |  | Example Output of 'FindSubjectStructuralSubsumingVariants' Operation |
| [FindSubjectTxImplicationsOutput](Parameters-FindSubjectTxImplicationsOutput.md) | Parameters |  | Example Output of 'FindSubjectTxImplications' Operation |
| [FindSubjectVariantsOutput](Parameters-FindSubjectVariantsOutput.md) | Parameters |  | Example Output of 'Find Subject Variants' Operation |
| [FullGenome-GRCh38](DocumentReference-FullGenome-GRCh38.md) | DocumentReference | Genomic Data File | Example for Genomic Data File FullGenome-GRCh38 |
| [genomicFileFatherBAM](DocumentReference-genomicFileFatherBAM.md) | DocumentReference | Genomic Data File | A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline |
| [genomicFileMotherBAM](DocumentReference-genomicFileMotherBAM.md) | DocumentReference | Genomic Data File | A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline |
| [genomicFileProbandBAM](DocumentReference-genomicFileProbandBAM.md) | DocumentReference | Genomic Data File | A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline |
| [genomicFileProbandVCF](DocumentReference-genomicFileProbandVCF.md) | DocumentReference | Genomic Data File | A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline |
| [genomicPatient](Patient-genomicPatient.md) | Patient |  | Example patient |
| [GenomicReportExample01](DiagnosticReport-GenomicReportExample01.md) | DiagnosticReport | Genomic Report | Example of a Report carrying a Genotype, Therapeutic Implication, and Medication Recommendation |
| [genomicServiceRequest](ServiceRequest-genomicServiceRequest.md) | ServiceRequest |  | Example of Molecular genetic test |
| [GenomicServiceRequestExample01](ServiceRequest-GenomicServiceRequestExample01.md) | ServiceRequest |  | Example for Service Request |
| [genomicSpecimen](Specimen-genomicSpecimen.md) | Specimen |  | Example of lung specimen obtained by biopsy |
| [GenomicSpecimenExample01](Specimen-GenomicSpecimenExample01.md) | Specimen |  | Example for Genomic Specimen |
| [GenomicSpecimenExample02](Specimen-GenomicSpecimenExample02.md) | Specimen |  | Example for Genomic Specimen from Buccal Swab |
| [genomicstudy-trio2](GenomicStudy-genomicstudy-trio2.md) | GenomicStudy |  | GenomicStudy example of a trio analysis |
| [genomicVCFfile-cnv](DocumentReference-genomicVCFfile-cnv.md) | DocumentReference | Genomic Data File | genomicVCFfile_cnv: A sample Document Reference instance representing a VCF file that may be used as input or output of a genomic analysis pipeline. |
| [genomicVCFfile-simple](DocumentReference-genomicVCFfile-simple.md) | DocumentReference | Genomic Data File | genomicVCFfile_simple: A sample Document Reference instance representing a VCF file that may be used as input or output of a genomic analysis pipeline. |
| [Genotype-Clinical-Trial-Example-using-haplotypes](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md) | Observation | Genotype | Example of a Genotype. A complete haplotype set defines a genotype. In this example the gneotype is dervied from observations of the underlying haplotypes. |
| [genotype-hla-a-glstring-r4](Observation-genotype-hla-a-glstring-r4.md) | Observation | Genotype | Genotype example: Sequence-based typing of HLA-A |
| [GenotypeExample1](Observation-GenotypeExample1.md) | Observation | Genotype | Example of a Genotype, Medication Recommendation, and MedicationStatement |
| [GenotypeExamplePharmVar](Observation-GenotypeExamplePharmVar.md) | Observation | Genotype | Example of a Genotype using Pharmvar Haplotypes |
| [GenRiskDiabetesT2](RiskAssessment-GenRiskDiabetesT2.md) | RiskAssessment |  | Polygenic Risk Score example |
| [GrouperEx01](Observation-GrouperEx01.md) | Observation |  | Generic grouping of Therapeutic Implication observations |
| [GrouperEx02](Observation-GrouperEx02.md) | Observation |  | Generic grouping of Genotype observations |
| [GrouperEx03](Observation-GrouperEx03.md) | Observation |  | Generic grouping of Regions Studied and Variant observations |
| [haplotype-hla-a-1-r4](Observation-haplotype-hla-a-1-r4.md) | Observation | Haplotype | Example Haplotype Sequence-based typing of HLA-A |
| [HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md) | Observation | Haplotype | Example of a Haplotype using PharmVar |
| [HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md) | Observation | Haplotype | Example of a Haplotype using PharmVar |
| [HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md) | Observation | Haplotype | Example of a Haplotype as part of a Haplotype Set (1 of 2). A complete haplotype set defines a genotype. |
| [HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md) | Observation | Haplotype | Example of a Haplotype as part of a Haplotype Set (2 of 2). A complete haplotype set defines a genotype. |
| [HER2byImmuneStainExample](Observation-HER2byImmuneStainExample.md) | Observation | Molecular Biomarker | Example for HER2 by immune stain |
| [HER2byImmunoassayExample](Observation-HER2byImmunoassayExample.md) | Observation | Molecular Biomarker | Example for HER2 by immunoassay |
| [HG00403](Patient-HG00403.md) | Patient |  | Example for Patient. Supports references to subject for multiple genomics reporting profile conforming instances. |
| [HLA-A-haplotype1](Observation-HLA-A-haplotype1.md) | Observation | Haplotype | Example for HLA-A-haplotype1 |
| [HLA-A-haplotype2](Observation-HLA-A-haplotype2.md) | Observation | Haplotype | Example for HLA-A-haplotype2 |
| [HLA-B-haplotype1](Observation-HLA-B-haplotype1.md) | Observation | Haplotype | Example for HLA-B-haplotype1 |
| [HLA-B-haplotype2](Observation-HLA-B-haplotype2.md) | Observation | Haplotype | Example for HLA-B-haplotype2 |
| [HLA-C-haplotype1](Observation-HLA-C-haplotype1.md) | Observation | Haplotype | Example for HLA-C-haplotype1 |
| [HLA-C-haplotype2](Observation-HLA-C-haplotype2.md) | Observation | Haplotype | Example for HLA-C-haplotype2 |
| [ISCN-CMLExample](Observation-ISCN-CMLExample.md) | Observation | Variant | Basic example for karyotype Variant expressed in ISCN |
| [ISCN-CMLImplication](Observation-ISCN-CMLImplication.md) | Observation | Diagnostic Implication | Basic example of a Diagnostic Implication for CML |
| [ISCN-NormalExample](Observation-ISCN-NormalExample.md) | Observation | Variant | Normal example for karyotype Variant expressed in ISCN |
| [lungMass](GenomicStudy-lungMass.md) | GenomicStudy |  | Example of solid tumor whole exome sequencing panel |
| [MedicationRecommendationExample1](Task-MedicationRecommendationExample1.md) | Task | Medication Recommendation | Example of a Medication Recommendation |
| [MedicationStatementWarfarin](MedicationStatement-MedicationStatementWarfarin.md) | MedicationStatement |  | MedicationStatement for Warfarin |
| [MicrosatelliteInstabilityExample01](Observation-MicrosatelliteInstabilityExample01.md) | Observation | Molecular Biomarker | Example for MSI |
| [molec-conseq1](Observation-molec-conseq1.md) | Observation | Molecular Consequence | Example Molecular Consequence that includes Loss of Function prediction |
| [molec-conseq2](Observation-molec-conseq2.md) | Observation | Molecular Consequence | Example Molecular Consequence |
| [molec-conseq3](Observation-molec-conseq3.md) | Observation | Molecular Consequence | Example Molecular Consequence |
| [molec-conseq4](Observation-molec-conseq4.md) | Observation | Molecular Consequence | Example Molecular Consequence |
| [MSH2-del-disease](Observation-MSH2-del-disease.md) | Observation | Diagnostic Implication | Example DiagnosticImplication - MSH2 deletion Hereditary cancer-predisposing syndrome |
| [MSH2-del-molc](Observation-MSH2-del-molc.md) | Observation | Molecular Consequence | Example Molecular Consequence MSH2 frameshift |
| [MSH2-del-var](Observation-MSH2-del-var.md) | Observation | Variant | Example for MSH2 deletion |
| [MSIExample](Observation-MSIExample.md) | Observation | Molecular Biomarker | Example for MSI |
| [MultipleRepeatExpansions](Observation-MultipleRepeatExpansions.md) | Observation | Variant | Repeat Expansion Variant with multiple motifs |
| [normalSpecimen](Specimen-normalSpecimen.md) | Specimen |  | Example for normal specimen |
| [NOTCH1-significance](Observation-NOTCH1-significance.md) | Observation | Diagnostic Implication | Example DiagnosticImplication - NOTCH1 uncertain significance |
| [NOTCH1-uncertain-molc](Observation-NOTCH1-uncertain-molc.md) | Observation | Molecular Consequence | Example Molecular Consequence NOTCH1 missense_variant |
| [NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md) | Observation | Variant | Example for NOTCH1 uncertain |
| [NTHL1-snv-disease](Observation-NTHL1-snv-disease.md) | Observation | Diagnostic Implication | Example DiagnosticImplication - NTHL1 SNV Hereditary cancer-predisposing syndrome |
| [NTHL1-snv-molc](Observation-NTHL1-snv-molc.md) | Observation | Molecular Consequence | Example Molecular Consequence NTHL1 SNV variant with nonsense codon |
| [NTHL1-snv-var](Observation-NTHL1-snv-var.md) | Observation | Variant | Example for NTHL1 SNV |
| [obs-idh-ex](Observation-obs-idh-ex.md) | Observation | Diagnostic Implication | Example DiagnosticImplication - Pathogenic for CF |
| [obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md) | Observation | Variant | SMN1 CNV companion for SMN1/SMN2 CNV example |
| [obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md) | Observation | Variant | SMN2 CNV companion for SMN1/SMN2 CNV example |
| [orderingPractitioner](Practitioner-orderingPractitioner.md) | Practitioner |  | Example of an ordering provider |
| [pathologistPractitioner](Practitioner-pathologistPractitioner.md) | Practitioner |  | Example of a pathologist |
| [PDL1Example](Observation-PDL1Example.md) | Observation | Molecular Biomarker | Example for PD-L1 |
| [performingOrganization](Organization-performingOrganization.md) | Organization |  | Example of a Pathology lab |
| [Pgx-geno-1001](Observation-Pgx-geno-1001.md) | Observation | Genotype | Example of a Genotype from eMERGE |
| [Pgx-geno-1002](Observation-Pgx-geno-1002.md) | Observation | Genotype | Example of a Genotype from eMERGE |
| [Pgx-geno-1003](Observation-Pgx-geno-1003.md) | Observation | Genotype | Example of a Genotype from eMERGE |
| [Pgx-var-1011](Observation-Pgx-var-1011.md) | Observation | Variant | Example variant 1011 |
| [Pgx-var-1012](Observation-Pgx-var-1012.md) | Observation | Variant | Example variant 1012 |
| [Pgx-var-1013](Observation-Pgx-var-1013.md) | Observation | Variant | Example variant 1013 |
| [Pgx-var-1014](Observation-Pgx-var-1014.md) | Observation | Variant | Example variant 1014 |
| [Pgx-var-1015](Observation-Pgx-var-1015.md) | Observation | Variant | Example variant 1015 |
| [Pgx-var-1016](Observation-Pgx-var-1016.md) | Observation | Variant | Example variant 1016 |
| [Pgx-var-1017](Observation-Pgx-var-1017.md) | Observation | Variant | Example variant 1017 |
| [Pgx-var-1018](Observation-Pgx-var-1018.md) | Observation | Variant | Example variant 1018 |
| [Pgx-var-1019](Observation-Pgx-var-1019.md) | Observation | Variant | Example variant 1019 |
| [Pgx-var-1020](Observation-Pgx-var-1020.md) | Observation | Variant | Example variant 1020 |
| [Pgx-var-1021](Observation-Pgx-var-1021.md) | Observation | Variant | Example variant 1021 |
| [PGxGenomicReportEMERGE](DiagnosticReport-PGxGenomicReportEMERGE.md) | DiagnosticReport | Genomic Report | Example of a Report carrying multiple Therapeutic Implications, Genotypes, and Variants |
| [PGxGenomicReportEMERGE-withGrouping](DiagnosticReport-PGxGenomicReportEMERGE-withGrouping.md) | DiagnosticReport | Genomic Report | Example of a Report carrying multiple Therapeutic Implications, Genotypes, and Variants |
| [PGXGenomicStudy](GenomicStudy-PGXGenomicStudy.md) | GenomicStudy |  | Example of PGX sequencing panel |
| [PGxRecEx01](Task-PGxRecEx01.md) | Task | Followup Recommendation | Example of a Medication Recommendation for alternatives to clopidogrel |
| [PGxRecEx02](Task-PGxRecEx02.md) | Task | Followup Recommendation | Example of a Medication Recommendation for alternatives to voriconazole |
| [PGxRecEx03](Task-PGxRecEx03.md) | Task | Followup Recommendation | Example of a Medication Recommendation for decreasing dosage for citalopram |
| [PGxRecEx04](Task-PGxRecEx04.md) | Task | Followup Recommendation | Example of a Medication Recommendation for decreasing dosage for escitalopram |
| [PGxRecEx05](Task-PGxRecEx05.md) | Task | Followup Recommendation | Example of a Medication Recommendation for decreasing dosage for amitriptyline |
| [PolyGenicDiagnosticImpExample](Observation-PolyGenicDiagnosticImpExample.md) | Observation | Diagnostic Implication | Example of a Diagnostic Implication for Diabetes Type 2 with a polygenic risk score. |
| [pop-allele-freq](Observation-pop-allele-freq.md) | Observation | Genomic Annotation | Example genomic annotation showing a population allele frequency |
| [practitioner02](Practitioner-practitioner02.md) | Practitioner |  | Example practitioner |
| [RepeatExpansion](Observation-RepeatExpansion.md) | Observation | Variant | Repeat Expansion Variant |
| [ROS1-Fusion](Observation-ROS1-Fusion.md) | Observation | Molecular Consequence | Example Molecular Consequence ROS1 Fusion |
| [ROS1-Fusion-disease](Observation-ROS1-Fusion-disease.md) | Observation | Diagnostic Implication | Example DiagnosticImplication - ROS1 disease |
| [ROS1-Fusion-therapuDrug](Observation-ROS1-Fusion-therapuDrug.md) | Observation | Therapeutic Implication | Example of ROS1 Fusion Therapeutic Implication for drug treatment |
| [ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md) | Observation | Therapeutic Implication | Example of ROS1 Fusion Therapeutic Implication for Clinical Trial |
| [ROS1-Fusion-var](Observation-ROS1-Fusion-var.md) | Observation | Variant | Example for ROS1 Fusion but as typically reported in PDF, without necessarily declaring a particular fusion partner |
| [SequencePhaseRelationExample1](Observation-SequencePhaseRelationExample1.md) | Observation | Sequence Phase Relationship | Example for sequence phase relation. |
| [SequencingProcedure](Procedure-SequencingProcedure.md) | Procedure |  | Very simple producure representing a genomic study's protocol |
| [servicerequest-hla-a-r4](ServiceRequest-servicerequest-hla-a-r4.md) | ServiceRequest |  | Example ServiceRequest for genomics |
| [SimpleVariantAnalysis-called](DocumentReference-SimpleVariantAnalysis-called.md) | DocumentReference | Genomic Data File | SimpleVariantAnalysis_called: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline. |
| [SNVexample](Observation-SNVexample.md) | Observation | Variant | Example Variant |
| [somaticPatient](Patient-somaticPatient.md) | Patient |  | Somatic example Patient |
| [somaticReport](DiagnosticReport-somaticReport.md) | DiagnosticReport | Genomic Report | Example somatic GenomicReport |
| [somaticServiceRequest](ServiceRequest-somaticServiceRequest.md) | ServiceRequest |  | Example for Somatic Testing Request |
| [somaticStudy](GenomicStudy-somaticStudy.md) | GenomicStudy |  | Example for somatic genetic study |
| [somaticVCFfile](DocumentReference-somaticVCFfile.md) | DocumentReference | Genomic Data File | Example for Genomic Data File somaticVCFfile |
| [specimen-hla-r4](Specimen-specimen-hla-r4.md) | Specimen |  | Example HLA specimen |
| [STAG2-insertion-molc](Observation-STAG2-insertion-molc.md) | Observation | Molecular Consequence | Example Molecular Consequence STAG2 frameshift |
| [STAG2-insertion-significance](Observation-STAG2-insertion-significance.md) | Observation | Diagnostic Implication | Example DiagnosticImplication - STAG2 likely pathogenic |
| [STAG2-insertion-var](Observation-STAG2-insertion-var.md) | Observation | Variant | Example for STAG2 insertion |
| [supervisorPractitioner](Practitioner-supervisorPractitioner.md) | Practitioner |  | Example of a supervisor |
| [Therapeutic-Implication-Clinical-Trial-2](Observation-Therapeutic-Implication-Clinical-Trial-2.md) | Observation | Therapeutic Implication | Example of a Therapeutic Implication for Carbamazepine |
| [Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md) | Observation | Therapeutic Implication | Example of a Therapeutic Implication for Clinical Trial |
| [TherapeuticImplicationExample1](Observation-TherapeuticImplicationExample1.md) | Observation | Therapeutic Implication | Example of a Therapeutic Implication for Carbamazepine |
| [therapuDrug1-interact-smn1-smn2](Observation-therapuDrug1-interact-smn1-smn2.md) | Observation | Therapeutic Implication | Antisense Oligonucelotide example of Therapeutic Implication for SMN1/SMN2 CNV example |
| [therapuDrug2-interact-smn1-smn2](Observation-therapuDrug2-interact-smn1-smn2.md) | Observation | Therapeutic Implication | Transgene example of Therapeutic Implication for SMN1/SMN2 CNV example |
| [therapuDrug3-interact-smn1-smn2](Observation-therapuDrug3-interact-smn1-smn2.md) | Observation | Therapeutic Implication | Small molecule example of Therapeutic Implication for SMN1/SMN2 CNV example |
| [TMB-therapuDrug](Observation-TMB-therapuDrug.md) | Observation | Therapeutic Implication | Example of high TMB Therapeutic Implication for drug treatment |
| [TMBExample](Observation-TMBExample.md) | Observation | Molecular Biomarker | Example for Tumor Mutation Burden |
| [triodenovo-software](Device-triodenovo-software.md) | Device |  | Triodenovo Software |
| [TumorMutationBurdenExample01](Observation-TumorMutationBurdenExample01.md) | Observation | Molecular Biomarker | Example for Tumor Mutation Burden |
| [tumorSpecimen](Specimen-tumorSpecimen.md) | Specimen |  | Example for tumor specimen |
| [TxImp01](Observation-TxImp01.md) | Observation | Therapeutic Implication | Example of a Therapeutic Implication from eMERGE |
| [TxImp02](Observation-TxImp02.md) | Observation | Therapeutic Implication | Example of a Therapeutic Implication from eMERGE |
| [TxImp03](Observation-TxImp03.md) | Observation | Therapeutic Implication | Example of a Therapeutic Implication from eMERGE |
| [TxImp04](Observation-TxImp04.md) | Observation | Therapeutic Implication | Example of a Therapeutic Implication from eMERGE |
| [TxImp05](Observation-TxImp05.md) | Observation | Therapeutic Implication | Example of a Therapeutic Implication from eMERGE |
| [TxImp06](Observation-TxImp06.md) | Observation | Therapeutic Implication | Example of a Therapeutic Implication from eMERGE |
| [UncallableRegions](DocumentReference-UncallableRegions.md) | DocumentReference | Genomic Data File | Representing a BED file that represents uncallable regions |
| [Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md) | Observation | Variant | Example for Somatic Variant and Clinical Trial |
| [variant-with-molec-consequences](Observation-variant-with-molec-consequences.md) | Observation | Variant | Variant with molecular consequences |
| [VariantExample](Observation-VariantExample.md) | Observation | Variant | Example for Variant NM_004448.4(ERBB2):c.2264_2278del |
| [VariantExample1](Observation-VariantExample1.md) | Observation | Variant | Example for Variant given by HGVS |
| [VariantExample2](Observation-VariantExample2.md) | Observation | Variant | Example for genomic Variant given by VCF columns |
| [WES-FullSequencedRegion-GRCh38](DocumentReference-WES-FullSequencedRegion-GRCh38.md) | DocumentReference | Genomic Data File | WES_FullSequencedRegion_GRCh38: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline. |
| [WES-UncallableRegions-GRCh38](DocumentReference-WES-UncallableRegions-GRCh38.md) | DocumentReference | Genomic Data File | Example for Genomic Data File WES-UncallableRegions-GRCh38 |
| [ZFHX3-significance](Observation-ZFHX3-significance.md) | Observation | Diagnostic Implication | Example DiagnosticImplication - ZFHX3 uncertain significance |
| [ZFHX3-uncertain-molc](Observation-ZFHX3-uncertain-molc.md) | Observation | Molecular Consequence | Example Molecular Consequence ZFHX3 missense_variant |
| [ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md) | Observation | Variant | Example for ZFHX3 uncertain |

