# Genetic Therapeutic Implications - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Genetic Therapeutic Implications**

## ValueSet: Genetic Therapeutic Implications 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/ValueSet/genetic-therapeutic-implications-vs | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:GeneticTherapeuticImplicationsVS |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement. | | |

 
Value Set for terms that describe a predicted ramification based on the presence of associated molecular finding(s). 

 **References** 

* [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on:

* Loinc v2.81
* SNOMED CT International edition 01-Feb 2025

This value set contains 21 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "genetic-therapeutic-implications-vs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/genetic-therapeutic-implications-vs",
  "version" : "4.0.0-ballot",
  "name" : "GeneticTherapeuticImplicationsVS",
  "title" : "Genetic Therapeutic Implications",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Value Set for terms that describe a predicted ramification based on the presence of associated molecular finding(s).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.\nThis value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement.",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "LA10315-2",
            "display" : "Ultrarapid metabolizer"
          },
          {
            "code" : "LA25391-6",
            "display" : "Normal metabolizer"
          },
          {
            "code" : "LA25390-8",
            "display" : "Rapid metabolizer"
          },
          {
            "code" : "LA10317-8",
            "display" : "Intermediate metabolizer"
          },
          {
            "code" : "LA9657-3",
            "display" : "Poor metabolizer"
          },
          {
            "code" : "LA19542-2",
            "display" : "Low Risk"
          },
          {
            "code" : "LA19541-4",
            "display" : "High Risk"
          },
          {
            "code" : "LA6676-6",
            "display" : "Resistant"
          },
          {
            "code" : "LA6677-4",
            "display" : "Responsive"
          },
          {
            "code" : "LA9660-7",
            "display" : "Presumed resistant"
          },
          {
            "code" : "LA9661-5",
            "display" : "Presumed responsive"
          },
          {
            "code" : "LA6682-4",
            "display" : "Unknown Significance"
          },
          {
            "code" : "LA6675-8",
            "display" : "Benign"
          },
          {
            "code" : "LA6674-1",
            "display" : "Presumed Benign"
          },
          {
            "code" : "LA9662-3",
            "display" : "Presumed non-responsive"
          },
          {
            "code" : "LA25392-4",
            "display" : "Increased function"
          },
          {
            "code" : "LA25393-2",
            "display" : "Normal function"
          },
          {
            "code" : "LA25395-7",
            "display" : "Decreased function"
          },
          {
            "code" : "LA25394-0",
            "display" : "Poor function"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "444734003",
            "display" : "Does not meet eligibility criteria for clinical trial (finding)"
          },
          {
            "code" : "399223003",
            "display" : "Patient eligible for clinical trial (finding)"
          }
        ]
      }
    ]
  }
}

```
