# Condition Inheritance Patterns - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Condition Inheritance Patterns**

## ValueSet: Condition Inheritance Patterns 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/ValueSet/condition-inheritance-mode-vs | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:ConditionInheritanceModeVS |

 
Value Set for specific transmission patterns of a condition in a pedigree 

 **References** 

* [Diagnostic Implication](StructureDefinition-diagnostic-implication.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (Unknown Code System)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "condition-inheritance-mode-vs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/condition-inheritance-mode-vs",
  "version" : "4.0.0-ballot",
  "name" : "ConditionInheritanceModeVS",
  "title" : "Condition Inheritance Patterns",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Value Set for specific transmission patterns of a condition in a pedigree",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://human-phenotype-ontology.org",
        "concept" : [
          {
            "code" : "HP:0000006",
            "display" : "Autosomal dominant inheritance"
          },
          {
            "code" : "HP:0000007",
            "display" : "Autosomal recessive inheritance"
          },
          {
            "code" : "HP:0001417",
            "display" : "X-linked inheritance"
          },
          {
            "code" : "HP:0001419",
            "display" : "X-linked recessive inheritance"
          },
          {
            "code" : "HP:0001423",
            "display" : "X-linked dominant inheritance"
          },
          {
            "code" : "HP:0001426",
            "display" : "Multifactorial inheritance"
          },
          {
            "code" : "HP:0001427",
            "display" : "Mitochondrial inheritance"
          },
          {
            "code" : "HP:0001442",
            "display" : "Typified by somatic mosaicism"
          },
          {
            "code" : "HP:0001450",
            "display" : "Y-linked inheritance"
          },
          {
            "code" : "HP:0001470",
            "display" : "Sex-limited expression"
          },
          {
            "code" : "HP:0003743",
            "display" : "Genetic anticipation"
          },
          {
            "code" : "HP:0003745",
            "display" : "Sporadic"
          },
          {
            "code" : "HP:0010983",
            "display" : "Oligogenic inheritance"
          },
          {
            "code" : "HP:0012274",
            "display" : "Autosomal dominant inheritance with paternal imprinting"
          },
          {
            "code" : "HP:0012275",
            "display" : "Autosomal dominant inheritance with maternal imprinting"
          },
          {
            "code" : "HP:0025352",
            "display" : "Typically de novo"
          },
          {
            "code" : "HP:0032113",
            "display" : "Semidominant inheritance"
          }
        ]
      }
    ]
  }
}

```
