# PGxRecEx01 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **PGxRecEx01**

## Example Task: PGxRecEx01

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Followup Recommendation](StructureDefinition-followup-recommendation.md)

**status**: Requested

**intent**: proposal

**code**: Consider alternative medication

**description**: 

For clopidogrel, individuals with this diplotype are expected to have significantly reduced platelet inhibition, increased residual platelet aggregation and increased risk for adverse cardiovascular events in response to clopidogrel. Alternative antiplatelet therapy (if no contraindication) is recommended. Refer to current guidelines for dosage and recommendations at https://cpicpgx.org/guidelines/guideline- for-clopidogrel-and-cyp2c19/

**for**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

### Reasons

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Poor metabolizer](Observation-TxImp01.md) |



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "PGxRecEx01",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/followup-recommendation"
    ]
  },
  "status" : "requested",
  "intent" : "proposal",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA26421-0",
        "display" : "Consider alternative medication"
      }
    ]
  },
  "description" : "For clopidogrel, individuals with this diplotype are expected to have significantly reduced platelet inhibition, increased residual platelet aggregation and increased risk for adverse cardiovascular events in response to clopidogrel. Alternative antiplatelet therapy (if no contraindication) is recommended. Refer to current guidelines for dosage and recommendations at https://cpicpgx.org/guidelines/guideline- for-clopidogrel-and-cyp2c19/",
  "for" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "reason" : [
    {
      "reference" : {
        "reference" : "Observation/TxImp01",
        "display" : "Poor metabolizer"
      }
    }
  ]
}

```
