# Therapy Assessed reference to a FHIR resource - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Therapy Assessed reference to a FHIR resource**

## Extension: Therapy Assessed reference to a FHIR resource 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapy-assessed-reference | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:TherapyAssessedReference |

Used to reference a specific therapy that was assessed (e.g. a FHIR ResearchStudy, a FHIR CarePlan, or a FHIR PlanDefinition).

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)
* Examples for this Extension: [Bundle/bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/therapy-assessed-reference)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-therapy-assessed-reference.csv), [Excel](StructureDefinition-therapy-assessed-reference.xlsx), [Schematron](StructureDefinition-therapy-assessed-reference.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "therapy-assessed-reference",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapy-assessed-reference",
  "version" : "4.0.0-ballot",
  "name" : "TherapyAssessedReference",
  "title" : "Therapy Assessed reference to a FHIR resource",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Used to reference a specific therapy that was assessed (e.g. a FHIR ResearchStudy, a FHIR CarePlan, or a FHIR PlanDefinition).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Observation.component"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Therapy Assessed reference to a FHIR resource",
        "definition" : "Used to reference a specific therapy that was assessed (e.g. a FHIR ResearchStudy, a FHIR CarePlan, or a FHIR PlanDefinition)."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapy-assessed-reference"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/CarePlan",
              "http://hl7.org/fhir/StructureDefinition/ResearchStudy",
              "http://hl7.org/fhir/StructureDefinition/PlanDefinition"
            ]
          }
        ]
      }
    ]
  }
}

```
