# Molecular Biomarker - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Molecular Biomarker**

## Resource Profile: Molecular Biomarker 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:MolecularBiomarker |

 
This profile is used to represent laboratory measurements of human inherent substances such as gene products, antigens and antibodies, and complex chemicals that result from post-translational processing of multi-gene products. 

### Scope and Usage

The term '**biomarker**' is broad, encompassing observable characteristics that indicate normal or abnormal biological processes and that are often used to assess prognosis or guide therapy. In the broad sense, many clinical and laboratory observations might be considered a 'biomarker'. '**Molecular biomarker**' is likewise broad, primarily encompassing laboratory measurements of human inherent substances such as gene products, antigens and antibodies, complex chemicals that result from post-translational processing of multi-gene products, etc. Molecular biomarkers include many different types of measurements, such as presence or absence of a chemical, or the level of a chemical. Here, we are primarily interested in those molecular biomarkers that have associated therapeutic implications, particularly in precision cancer care, including but not limited to: cell receptor levels (e.g. ER, PR, HER2); molecular sequence adjacent observations (e.g. microsatellite instability, tumor mutation burden, gene promoter methylation); cell receptor ligands (e.g. PD-L1); proteins, antigens, and antibodies (e.g. HLA type).

The `code` is bound to the [Molecular Biomarker Codes](ValueSet-molecular-biomarker-code-vs.md) ValueSet. It is **not** a comprehensive list of biomarkers and only provides representative examples drawn from LOINC and NCI Thesaurus.

Where the biomarker is a proxy or higher level abstraction for one or more underlying genetic observations, the `derivedFrom` attribute can be used to reference the source variant(s), haplotype(s) and/or genotype(s).

Component '`gene-studied`' is an optional and repeating field for representing the gene or genes from which the observed substance is derived.

Component '`biomarker-category`' is a repeating field that provides for a categorization of a given biomarker observation.

In the absence of a well defined and comprehensive value set for molecular biomarkers, we provide general guidance for the construction of a biomarker instance for an arbitrary biomarker. A typical use of this profile includes (1) identify the appropriate observation.code (e.g. drawing from LOINC, NCIt, etc); (2) add an observation.category of 'biomarker-category'; (3) populate component:gene-studied if applicable; (4) optionally populate component:biomarker-category; (5) populate other applicable observation fields similar to how you would populate them for regular lab observations (e.g. include observation.value, observation.effectiveDateTime, etc).

### Biomarker Ontology

The [Molecular Biomarker Ontology code system](CodeSystem-molecular-biomarker-ontology-cs.md) provides a categorization of biomarkers along several axes. A given lab test can be associated with more than one category within more than one axis. For example, LOINC code [85337-4](https://loinc.org/85337-4/) represents Estrogen receptor antigen in tissue by immune stain. It can be categorized by physiologic role of cell receptor and antigen; by molecule type of protein; and by method of immune stain.

#### Molecular Biomarker Ontology with examples

* Molecular biomarker categorized by physiologic role
* cell receptor: [ER](https://loinc.org/85337-4/), [HER2 by IA](https://loinc.org/72382-5/), [HLA class I](https://loinc.org/77637-7/), [PR](https://loinc.org/40557-1/)
* cell receptor ligand: [PD-L1](https://loinc.org/85147-7/)
* antibody: [Neutrophil Ab](https://loinc.org/59025-7/), [Lactoferrin Ab by immunoassay](https://loinc.org/59003-4/)
* antigen: [ER](https://loinc.org/85337-4/), [HLA class I](https://loinc.org/77637-7/), [Insulin](https://loinc.org/10495-0/), [PR](https://loinc.org/40557-1/)

#### Molecular biomarker categorized by molecule type

* carbohydrate: [Urine carbohydrates](https://loinc.org/16550-6/)
* lipid: [Serum lipids](https://loinc.org/2569-2/)
* protein: [ER](https://loinc.org/85337-4/), [HER2 by IA](https://loinc.org/72382-5/), [Hgb A2](https://loinc.org/4551-8/), [HLA class I](https://loinc.org/77637-7/), [Neutrophil Ab](https://loinc.org/59025-7/), [PR](https://loinc.org/40557-1/), [PSA](https://loinc.org/19195-7/), [Insulin](https://loinc.org/10495-0/), [Lactoferrin Ab by immunoassay](https://loinc.org/59003-4/)
* nucleic acid: [MGMT gene methylation](https://loinc.org/64083-9/)

#### Molecular biomarker categorized by method

* Enzyme assay: [Lactoferrin Ab by immunoassay](https://loinc.org/59003-4/)
* Flow cytometry: [Neutrophil Ab](https://loinc.org/59025-7/)
* Immune stain: [ER](https://loinc.org/85337-4/), [Insulin](https://loinc.org/10495-0/), [MSI by immune stain](https://loinc.org/62862-8/), [PD-L1](https://loinc.org/85147-7/), [PR](https://loinc.org/40557-1/)
* Immunoassay: [HER2 by IA](https://loinc.org/72382-5/), [HLA class I](https://loinc.org/77637-7/), [Lactoferrin Ab by immunoassay](https://loinc.org/59003-4/)
* Methylation analysis: [MGMT gene methylation](https://loinc.org/64083-9/)
* Molgen: [MSI](https://loinc.org/81704-9/), [TMB](https://loinc.org/94077-5/)

#### Biomarker Categories

Biomarker categories can be associated with LOINC value sets to facilitate retrieval, as shown in this non-normative example table.

| | |
| :--- | :--- |
| cell receptor | [ER](https://loinc.org/85337-4/),[HER2 by IA](https://loinc.org/72382-5/),[HLA class I](https://loinc.org/77637-7/),[PR](https://loinc.org/40557-1/) |
| protein | [ER](https://loinc.org/85337-4/),[HER2 by IA](https://loinc.org/72382-5/),[Hgb A2](https://loinc.org/4551-8/),[HLA class I](https://loinc.org/77637-7/),[Neutrophil Ab](https://loinc.org/59025-7/),[PR](https://loinc.org/40557-1/),[PSA](https://loinc.org/19195-7/),[Insulin](https://loinc.org/10495-0/),[Lactoferrin Ab by immunoassay](https://loinc.org/59003-4/) |
| immune stain | [ER](https://loinc.org/85337-4/),[Insulin](https://loinc.org/10495-0/),[MSI by immune stain](https://loinc.org/62862-8/),[PD-L1](https://loinc.org/85147-7/),[PR](https://loinc.org/40557-1/) |

### Other Guidance

If implementers have additional annotations for biomarkers, the Molecular Biomarker profile is defined to allow flexibility. See the section on [flexibility](general.md#flexibility) for additional guidance, especially the guidance for the Open Slicing allowed on `Observation.component`.

**Usages:**

* Refer to this Profile: [Genomic Report](StructureDefinition-genomic-report.md) and [Genomic Implication](StructureDefinition-implication.md)
* Examples for this Profile: [Observation/HER2byImmuneStainExample](Observation-HER2byImmuneStainExample.md), [Observation/HER2byImmunoassayExample](Observation-HER2byImmunoassayExample.md), [Observation/MSIExample](Observation-MSIExample.md), [Observation/MicrosatelliteInstabilityExample01](Observation-MicrosatelliteInstabilityExample01.md)...Show 3 more,[Observation/PDL1Example](Observation-PDL1Example.md),[Observation/TMBExample](Observation-TMBExample.md)and[Observation/TumorMutationBurdenExample01](Observation-TumorMutationBurdenExample01.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/molecular-biomarker)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-molecular-biomarker.csv), [Excel](StructureDefinition-molecular-biomarker.xlsx), [Schematron](StructureDefinition-molecular-biomarker.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "molecular-biomarker",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker",
  "version" : "4.0.0-ballot",
  "name" : "MolecularBiomarker",
  "title" : "Molecular Biomarker",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "This profile is used to represent laboratory measurements of human inherent substances such as gene products, antigens and antibodies, and complex chemicals that result from post-translational processing of multi-gene products.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding"
            }
          ],
          "description" : "Slice based on the category.code pattern",
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Observation.category:labCategory",
        "path" : "Observation.category",
        "sliceName" : "labCategory",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.category:labCategory.coding",
        "path" : "Observation.category.coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      },
      {
        "id" : "Observation.category:mbCategory",
        "path" : "Observation.category",
        "sliceName" : "mbCategory",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.category:mbCategory.coding",
        "path" : "Observation.category.coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
          "code" : "biomarker-category"
        }
      },
      {
        "id" : "Observation.category:geCategory",
        "path" : "Observation.category",
        "sliceName" : "geCategory",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.category:geCategory.coding",
        "path" : "Observation.category.coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Code for the biomarker",
        "definition" : "The code is used to represent the biomarker - laboratory measurements of human inherent substances such as gene products, antigens and antibodies, and complex chemicals that result from post-translational processing of multi-gene products.",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/molecular-biomarker-code-vs"
        }
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "description" : "Slice based on the reference profile pattern",
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.derivedFrom:variant",
        "path" : "Observation.derivedFrom",
        "sliceName" : "variant",
        "short" : "Variant the biomarker is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom:genotype",
        "path" : "Observation.derivedFrom",
        "sliceName" : "genotype",
        "short" : "Genotype the biomarker is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom:haplotype",
        "path" : "Observation.derivedFrom",
        "sliceName" : "haplotype",
        "short" : "Haplotype the biomarker is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "description" : "Slice based on the component.code pattern",
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:gene-studied",
        "path" : "Observation.component",
        "sliceName" : "gene-studied",
        "short" : "Gene Studied",
        "definition" : "The gene(s) directly or indirectly assessed by the biomarker.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:gene-studied.code",
        "path" : "Observation.component.code",
        "short" : "48018-6",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48018-6"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:gene-studied.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "The HGNC gene symbol is to be used as display text and the HGNC gene ID used as the code. If no HGNC code issued for this gene yet, NCBI gene IDs SHALL be used.",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/hgnc-vs"
        }
      },
      {
        "id" : "Observation.component:biomarker-category",
        "path" : "Observation.component",
        "sliceName" : "biomarker-category",
        "short" : "Biomarker Category",
        "definition" : "A categorization of a given biomarker observation.",
        "comment" : "Component biomarker-category is an optional and repeating field that provides for a categorization of a given biomarker observation. The example 'molecular biomarker ontology' value set provides a categorization of biomarkers along several axes. A given lab test can be associated with more than one category within more than one axis. For example, LOINC code 85337-4 represents Estrogen receptor antigen in tissue by immune stain. It can be categorized by physiologic role of cell receptor and antigen; by molecule type of protein; and by method of immune stain.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:biomarker-category.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "biomarker-category"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:biomarker-category.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "cell receptor | antigen | protein | immune stain",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/molecular-biomarker-category-vs"
        }
      }
    ]
  }
}

```
