# Genomic Implication - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Genomic Implication**

## Resource Profile: Genomic Implication ( Abstract ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/implication | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:GenomicImplication |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. | | |

 
Properties common to genomic implications expressed as computable discrete elements. 

The Genomic Implication profile is an abstract profile for therapeutic and diagnostic implications and molecular consequences. Implications are relevant information which are derived from the presence of a haplotype, genotype, variant or molecular biomarker. This portion of the implementation guide relies on the content in the [General Genomic Reporting](general.md) and [Variant Reporting](sequencing.md) portions of this implementation guide.

At the heart of many genomic reports are findings ([variants](StructureDefinition-variant.md), [haplotypes](StructureDefinition-haplotype.md), [genotypes](StructureDefinition-genotype.md), [biomarkers](StructureDefinition-molecular-biomarker.md)) and annotations derived from those findings ([diagnostic implications](StructureDefinition-diagnostic-implication.md), [therapeutic implications](StructureDefinition-therapeutic-implication.md), [predicted molecular consequences](StructureDefinition-molecular-consequence.md), [other genomic annotations](StructureDefinition-genomic-annotation.md)), as shown in the following figure:

This profile defines a common set of elements for other Implications:

* `derivedFrom` is a required field that provides an explicit reference from an implication to the variant(s) / haplotype(s) / genotype(s) / molecular biomarker(s) from which the implication is derived.
* `workflow-relatedArtifact (base extension) (component)` supports conveying references to citations, supporting documentation and other information relevant to the asserted implication, such as documentation which applies to the full implication Observation or to the component level information specific to the component's code and value (such as documentation supporting a specific clinical significance or evidence level value).
* `evidence-level (component)` indicates the strength of the evidence behind the asserted implication.
* `clinical-significance (component)` indicates the clinical impact of an implication.
* `knowledge-base (component)` indicates the database from which the annotation is derived. Annotations are obtained from different knowledge bases (e.g. [Clinvar](https://www.ncbi.nlm.nih.gov/clinvar/), [gnomAD](https://gnomad.broadinstitute.org/), [1000 Genomes](https://www.internationalgenome.org/)). Knowledge bases continue to evolve, with new ones being developed, and existing ones being updated/revised.
* `annotation-pipeline (component)` indicates the name of the data pipeline that processed the genomic data file.

#### evidence-level versus clinical-significance

**evidence-level**: The amount of observed support for the association between an implication and a variant / haplotype / genotype / biomarker. There are dozens if not hundreds of evidence-level value sets, generally providing an ordinal range of codes from low evidence (e.g. 'predicted', 'case report', '1-star') to high evidence (e.g. 'professional society guideline', 'expert panel consensus', '1A').

**clinical-significance**: The clinical impact of an implication on a person's health. There are dozens if not hundreds of clinical-significance value sets, generally providing an ordinal range of codes from low significance (e.g. 'benign') to high significance (e.g. 'pathogenic', 'oncogenic','predictive of drug response').

While **evidence** and **significance** are orthogonal concepts, some codes conflate the two (e.g. 'expert panel consensus of strong efficacy', 'strong evidence refutes the clinical utility of this drug', 'case report evidence of pathogenicity'). In general, using discrete evidence and significance codes allow for a more precise characterization of an implication. Where an implementation is using a conflated code, we recommend communicating that code in the evidence-level field.

Examples of other code sets for evidence-level and clinical-significance:

* [ACMG_Level of evidence](https://loinc.org/LL5356-2/)
* [Oncokb levels](https://www.oncokb.org/levels#version=V2)
* US FDA levels
* AMP/ASCO/CAP levels
* Classification on ClinVar submitted records
* [Bioportal clinical variant interpretation](https://bioportal.bioontology.org/ontologies/NGBO/?p=classes&conceptid=http://purl.obolibrary.org/obo/ngbo.owl/NGBO_6000302)
* [CIViC Evidence](https://civic.readthedocs.io/en/latest/model/evidence/overview.html)
* [CIViC Significance](https://civic.readthedocs.io/en/latest/model/evidence/significance.html)

#### Differentiating AND vs OR

There are several cases where it is necessary to differentiate 'AND' conditions (e.g. both drug X AND drug Y, in combination, are indicated in the presence of a variant) vs. 'OR' conditions (e.g., either drug X OR drug Y are indicated in the presence of a variant).

This situation is not unique to genomic implications, and arises elsewhere within FHIR (e.g. [FHIR Search](https://www.hl7.org/fhir/search.html#combining)) and outside of FHIR (e.g., [ClinVar submission API](https://www.ncbi.nlm.nih.gov/clinvar/docs/api_http/) condition set). To be consistent with other precedents:

Where implications have fields with cardinality > 1, the inclusion of multiple values within a field SHALL indicate an 'AND' condition. An 'OR' condition SHALL be represented by multiple observation instances.

Implication fields affected by this guidance include:

[Molecular consequences](StructureDefinition-molecular-consequence.md): derivedFrom, evidence-level, feature-consequence.

[Therapeutic implications](StructureDefinition-therapeutic-implication.md): derivedFrom, evidence-level, therapeutic-implication, phenotypic-treatment-context, medication-assessed, therapy-assessed.

[Diagnostic implications](StructureDefinition-diagnostic-implication.md): derivedFrom, evidence-level, predicted-phenotype, genomic-risk-assessment.

[Genomic annotations](StructureDefinition-genomic-annotation.md): derivedFrom, evidence-level, population-allele-frequency, conservation-score.

Here are examples of these rules with DiagnosticImplication (but the principles would apply to any Implication):

#### Example 1: Variant X is pathogenic for Disease Y AND Disease Z (in combination)

**Implementation:** One DiagnosticImplication with two `predicted-phenotype` instances for Disease Y and Disease Z that is `derivedFrom` one Variant for VariantX

#### Example 2: Variant X might be pathogenic for Disease Y alone, or Disease Z alone

**Implementation:** Two DiagnosticImplications, one with `predicted-phenotype` for DiseaseY, second with `predicted-phenotype` for DiseaseZ, and both are `derivedFrom` the same Variant for VariantX

#### Example 3: Variant X AND Variant Y (in combination) are pathogenic for Disease Z

**Implementation:** One DiagnosticImplications with `predicted-phenotype` for DiseaseZ that is `derivedFrom` the two Variants (VariantX and VariantY)

#### Example 4: Variant X OR Variant Y might be pathogenic for Disease Z

**Implementation:** Two DiagnosticImplications, each with `predicted-phenotype` for DiseaseZ, one that is `derivedFrom` a Variant for VariantX, the other that is `derivedFrom` a Variant for VariantY

**Usages:**

* Derived from this Profile: [Diagnostic Implication](StructureDefinition-diagnostic-implication.md), [Genomic Annotation](StructureDefinition-genomic-annotation.md), [Molecular Consequence](StructureDefinition-molecular-consequence.md) and [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/implication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-implication.csv), [Excel](StructureDefinition-implication.xlsx), [Schematron](StructureDefinition-implication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "implication",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/implication",
  "version" : "4.0.0-ballot",
  "name" : "GenomicImplication",
  "title" : "Genomic Implication",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Properties common to genomic implications expressed as computable discrete elements.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.",
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.extension:workflow-relatedArtifact",
        "path" : "Observation.extension",
        "sliceName" : "workflow-relatedArtifact",
        "comment" : "Note that in contrast this extension, the supportingInfo extension references other resources from the patient record that were used in creating the resource.",
        "requirements" : "This SHOULD be used to deliver artifacts that are relevant to the implication.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "max" : "0"
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "min" : 1
      },
      {
        "id" : "Observation.derivedFrom:variant",
        "path" : "Observation.derivedFrom",
        "sliceName" : "variant",
        "short" : "Variant the implication is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom:genotype",
        "path" : "Observation.derivedFrom",
        "sliceName" : "genotype",
        "short" : "Genotype the implication is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom:haplotype",
        "path" : "Observation.derivedFrom",
        "sliceName" : "haplotype",
        "short" : "Haplotype the implication is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom:biomarker",
        "path" : "Observation.derivedFrom",
        "sliceName" : "biomarker",
        "short" : "MolecularBiomarker the implication is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component"
      },
      {
        "id" : "Observation.component.extension",
        "path" : "Observation.component.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact",
        "requirements" : "This SHOULD be used to deliver artifacts that are specific to the component code and value.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:evidence-level",
        "path" : "Observation.component",
        "sliceName" : "evidence-level",
        "short" : "Level of Evidence",
        "definition" : "The amount of observed support for the association between an implication and a variant / haplotype / genotype / biomarker. There are dozens if not hundreds of evidence-level value sets, generally providing an ordinal range of codes from low evidence (e.g. 'predicted', 'case report', '1-star') to high evidence (e.g. 'professional society guideline', 'expert panel consensus', '1A').",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:evidence-level.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact",
        "requirements" : "This SHOULD be used to deliver artifacts that are specific to the component code and value.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:evidence-level.code",
        "path" : "Observation.component.code",
        "short" : "93044-6",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "93044-6"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:evidence-level.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "1A | 1B | 2A | 2B | 3 | 4 | 4-star | 3-star | 2-star | 1-star | no-star",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "PharmGKB or ClinVar",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/evidence-level-example-vs"
        }
      },
      {
        "id" : "Observation.component:clinical-significance",
        "path" : "Observation.component",
        "sliceName" : "clinical-significance",
        "short" : "Clinical significance",
        "definition" : "The clinical impact of an implication on a person's health. There are dozens if not hundreds of clinical-significance value sets, generally providing an ordinal range of codes from low significance (e.g. 'benign') to high significance (e.g. 'pathogenic', 'oncogenic','predictive of drug response').",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:clinical-significance.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact",
        "requirements" : "This SHOULD be used to deliver artifacts that are specific to the component code and value.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:clinical-significance.code",
        "path" : "Observation.component.code",
        "short" : "53037-8",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "53037-8"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:clinical-significance.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Pathogenic | Likely pathogenic | Uncertain significance | Likely benign | Benign",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://loinc.org/vs/LL4034-6"
        }
      },
      {
        "id" : "Observation.component:knowledge-base",
        "path" : "Observation.component",
        "sliceName" : "knowledge-base",
        "short" : "Knowledge Base",
        "definition" : "The database from which the annotation is derived",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:knowledge-base.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact",
        "requirements" : "This SHOULD be used to deliver artifacts that are specific to the component code and value.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:knowledge-base.code",
        "path" : "Observation.component.code",
        "short" : "knowledge-base",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "knowledge-base"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:knowledge-base.value[x]",
        "path" : "Observation.component.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/knowledge-base-version-vs"
        }
      },
      {
        "id" : "Observation.component:annotation-pipeline",
        "path" : "Observation.component",
        "sliceName" : "annotation-pipeline",
        "short" : "Annotation Pipeline",
        "definition" : "The name of the data pipeline that processed the genomic data file",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:annotation-pipeline.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact",
        "requirements" : "This SHOULD be used to deliver artifacts that are specific to the component code and value.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:annotation-pipeline.code",
        "path" : "Observation.component.code",
        "short" : "annotation-pipeline",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "annotation-pipeline"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:annotation-pipeline.value[x]",
        "path" : "Observation.component.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
