# Haplotype - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Haplotype**

## Resource Profile: Haplotype 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:Haplotype |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. | | |

 
Assertion of a particular haplotype on the basis of one or more variants. 

Haplotype describe a set of genomic [variations](StructureDefinition-variant.md) that appear on a single strand of DNA - and which are therefore typically inherited together. Many haplotypes are expressed as simple strings, and can be conveyed in `valueCodeableConcept.text`. In some cases, haplotypes are sufficiently standardized to be conveyed as codes in `valueCodeableConcept.code`.

For Pharmacogenomics, implementers SHOULD send coded haplotypes. Here is an example using PharmVar:

* Coded PGx 

```
{ 
"valueCodeableConcept": { 
  "coding": [{ 
    "system": "http://www.pharmvar.org", 
    "code": "PV01777", 
    "display": "CYP2C9*3.002" }],
  "text": "CYP2C9*3B" 
  } 
}

```

 

For both genotypes and haplotypes, reporting the structured variant data is optional. However, implementers SHOULD when possible. For example, sending PGX star-alleles without variant-level information is not best practice as it is both potentially ambiguous and can preclude future utility of the report.

Review the [Genotypes](StructureDefinition-genotype.md) page for guidance on reporting genotypes and haplotypes together.

**Usages:**

* Refer to this Profile: [Genomic Report](StructureDefinition-genomic-report.md), [Genotype](StructureDefinition-genotype.md), [Haplotype](StructureDefinition-haplotype.md), [Genomic Implication](StructureDefinition-implication.md)...Show 2 more,[Molecular Biomarker](StructureDefinition-molecular-biomarker.md)and[Sequence Phase Relationship](StructureDefinition-sequence-phase-relationship.md)
* Examples for this Profile: [Observation/HLA-A-haplotype1](Observation-HLA-A-haplotype1.md), [Observation/HLA-A-haplotype2](Observation-HLA-A-haplotype2.md), [Observation/HLA-B-haplotype1](Observation-HLA-B-haplotype1.md), [Observation/HLA-B-haplotype2](Observation-HLA-B-haplotype2.md)...Show 7 more,[Observation/HLA-C-haplotype1](Observation-HLA-C-haplotype1.md),[Observation/HLA-C-haplotype2](Observation-HLA-C-haplotype2.md),[Observation/HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md),[Observation/HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md),[Observation/HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md),[Observation/HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md)and[Observation/haplotype-hla-a-1-r4](Observation-haplotype-hla-a-1-r4.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/haplotype)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-haplotype.csv), [Excel](StructureDefinition-haplotype.xlsx), [Schematron](StructureDefinition-haplotype.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "haplotype",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype",
  "version" : "4.0.0-ballot",
  "name" : "Haplotype",
  "title" : "Haplotype",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Assertion of a particular haplotype on the basis of one or more variants.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.",
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/finding",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Haplotype"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "84414-2",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84414-2"
            }
          ]
        }
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "Haplotype name",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Binding not yet standardized"
        }
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "short" : "Directly measured | Family DNA | Family history | Inferred from population data",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://loinc.org/vs/LL4050-2"
        }
      },
      {
        "id" : "Observation.derivedFrom:haplotype",
        "path" : "Observation.derivedFrom",
        "sliceName" : "haplotype",
        "short" : "Haplotype this haplotype is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom:variant",
        "path" : "Observation.derivedFrom",
        "sliceName" : "variant",
        "short" : "Variant this haplotype is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom:molecular-sequence",
        "path" : "Observation.derivedFrom",
        "sliceName" : "molecular-sequence",
        "short" : "MolecularSequence this haplotype is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/MolecularSequence"]
          }
        ]
      }
    ]
  }
}

```
