# Genotype - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Genotype**

## Resource Profile: Genotype 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:Genotype |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. | | |

 
Assertion of a particular genotype on the basis of one or more variants or haplotypes. 

Genotype describes combinations of genomic variations that together are associated with a particular phenotype - i.e., a specific physical, behavioral, or risk-associated difference associated with the organism whose specimen was tested. Genotype is used to convey corresponding [haplotypes](StructureDefinition-haplotype.md) or [variations](StructureDefinition-variant.md) at a particular locus. Many genotypes are expressed as simple strings, and can be conveyed in `valueCodeableConcept.text`. In some cases, genotypes are sufficiently standardized to be conveyed as codes in `valueCodeableConcept.code`.

For HLA, KIR, and other genes in the immunogenomics domain, the National Marrow Donor Program (NMDP) led a community effort to define the Genotype List String (GL String) grammar, described [here](https://glstring.org). Notably, the GL String uses '+' as a delimiter between alleles in a genotype. It also has delimiters for ambiguous genotypes, allele lists, and haplotypes.

For Pharmacogenomics, implementers SHOULD send coded haplotypes, and for genotypes (diplotypes) MAY use a simple, human readable grammar of:

[HGNC gene symbol], followed by white space, followed by a slash ('/') delimited list of haplotype names].

Here are some examples that are standardized, note that there are examples which still lack standardization today.

* Coded HLA (glstring) 

```
{
"valueCodeableConcept": { 
"coding": [{ 
    "system": "http://glstring.org", 
    "version": "1.0", 
    "code": "#hla#3.23#HLA-A*01:01:01:01/HLA-A*01:02+HLA-A*24:02:01:01" 
  }] 
}
}

```

 
* PGx Genotype (textually represents the CYP2C9 *2C haplotype (or 'star allele') on one chromosome and the CYP2C9 *1A haplotype on the homologous chromosome) 

```
{ 
"valueCodeableConcept": { 
  "text": "CYP2C9 *2C/*1A" 
} 
}

```

 

For both genotypes and haplotypes, reporting the structured variant data is optional. However, implementers SHOULD when possible. For example, sending PGX star-alleles without variant-level information is not best practice as it is both potentially ambiguous and can preclude future utility of the report.

**Usages:**

* Refer to this Profile: [Genomic Report](StructureDefinition-genomic-report.md), [Genomic Implication](StructureDefinition-implication.md) and [Molecular Biomarker](StructureDefinition-molecular-biomarker.md)
* Examples for this Profile: [Observation/Genotype-Clinical-Trial-Example-using-haplotypes](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md), [Observation/GenotypeExample1](Observation-GenotypeExample1.md), [Observation/GenotypeExamplePharmVar](Observation-GenotypeExamplePharmVar.md), [Observation/Pgx-geno-1001](Observation-Pgx-geno-1001.md)...Show 3 more,[Observation/Pgx-geno-1002](Observation-Pgx-geno-1002.md),[Observation/Pgx-geno-1003](Observation-Pgx-geno-1003.md)and[Observation/genotype-hla-a-glstring-r4](Observation-genotype-hla-a-glstring-r4.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/genotype)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-genotype.csv), [Excel](StructureDefinition-genotype.xlsx), [Schematron](StructureDefinition-genotype.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "genotype",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype",
  "version" : "4.0.0-ballot",
  "name" : "Genotype",
  "title" : "Genotype",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Assertion of a particular genotype on the basis of one or more variants or haplotypes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.",
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/finding",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Genotype"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "84413-4",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84413-4"
            }
          ]
        }
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "Genotype name",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Binding not yet defined"
        }
      },
      {
        "id" : "Observation.derivedFrom:haplotype",
        "path" : "Observation.derivedFrom",
        "sliceName" : "haplotype",
        "short" : "Haplotype this genotype is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom:variant",
        "path" : "Observation.derivedFrom",
        "sliceName" : "variant",
        "short" : "Variant this genotype is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom:molecular-sequence",
        "path" : "Observation.derivedFrom",
        "sliceName" : "molecular-sequence",
        "short" : "MolecularSequence this genotype is derived from",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/MolecularSequence"]
          }
        ]
      }
    ]
  }
}

```
