# Genomic Base - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Genomic Base**

## Resource Profile: Genomic Base ( Abstract ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-base | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:GenomicBase |

 
Base profile that defines characteristics shared by all genetic observations. 

### Scope and Usage

This profile is the base profile for all other profiles in this guide, defining a set of constraints that are applicable across all observations.

#### Common Elements

* `secondary-finding (extension)` can flag an observation as a secondary finding, a finding that is unrelated to the primary purpose for the test
* `partOf` is limited to references which are applicable to genomic observations
* `category` slices required two categories for all genomic observations in order to facilitate more efficient queries
* `note` is a [CodedAnnotation](StructureDefinition-coded-annotation.md) that allow all comments to also contain coded type
* `derivedFrom` is limited to references which are applicable to genomic observations
* `conclusion-string (component)` represents a summary conclusion to provide interpretation or impression guidance

**Usages:**

* Derived from this Profile: [Genomic Finding](StructureDefinition-finding.md) and [Genomic Implication](StructureDefinition-implication.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/genomic-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-genomic-base.csv), [Excel](StructureDefinition-genomic-base.xlsx), [Schematron](StructureDefinition-genomic-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "genomic-base",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-base",
  "version" : "4.0.0-ballot",
  "name" : "GenomicBase",
  "title" : "Genomic Base",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Base profile that defines characteristics shared by all genetic observations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.extension",
        "path" : "Observation.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.extension:secondary-finding",
        "path" : "Observation.extension",
        "sliceName" : "secondary-finding",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/observation-secondaryFinding"
            ]
          }
        ]
      },
      {
        "id" : "Observation.extension:body-structure",
        "path" : "Observation.extension",
        "sliceName" : "body-structure",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/bodySite"]
          }
        ]
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding"
            }
          ],
          "description" : "Slice based on the category.code pattern",
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Observation.category:labCategory",
        "path" : "Observation.category",
        "sliceName" : "labCategory",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.category:labCategory.coding",
        "path" : "Observation.category.coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      },
      {
        "id" : "Observation.category:geCategory",
        "path" : "Observation.category",
        "sliceName" : "geCategory",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.category:geCategory.coding",
        "path" : "Observation.category.coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      },
      {
        "id" : "Observation.note",
        "path" : "Observation.note",
        "short" : "Comments about the Observation that also contain a coded type",
        "comment" : "May include general statements about the observation, or statements about significant, unexpected or unreliable results values, or information about its source when relevant to its interpretation.\nThe CodedAnnotation data type, while not allowing for or intending to make the content computable, does allow the author to indicate the type of note. This does not replace the use of interpretation, value, or component values.\nOne important note is that Annotation is a FHIR data type, this is **NOT** about annotations in the genomic context.",
        "requirements" : "Need to be able to provide free text additional information. Notes SHALL NOT contain information which can be captured in a structured way.",
        "type" : [
          {
            "code" : "Annotation",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/coded-annotation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "description" : "Slice based on the reference profile pattern",
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "description" : "Slice based on the component.code pattern",
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:conclusion-string",
        "path" : "Observation.component",
        "sliceName" : "conclusion-string",
        "short" : "Clinical Conclusion",
        "definition" : "Concise and clinically contextualized summary conclusion (interpretation/impression) of the observation",
        "comment" : "An example would be the interpretative information, typically canned, about a variant identified in the patient.",
        "requirements" : "Need to be able to provide a conclusion that is not lost among the basic result data.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:conclusion-string.code",
        "path" : "Observation.component.code",
        "short" : "conclusion-string",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "conclusion-string"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:conclusion-string.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Summary conclusion (interpretation/impression)",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
