# Genomic Annotation - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Genomic Annotation**

## Resource Profile: Genomic Annotation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-annotation | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:GenomicAnnotation |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. | | |

 
Profile for communicating miscellaneous genomic annotations that are neither Diagnostic Implications, Therapeutic Implications, nor Molecular Consequences. 

This section provides guidance for reporting of miscellaneous genomic annotations. Several types of annotations (e.g. population allele frequency) are important for clinical decision making, but are neither [Therapeutic Implications](StructureDefinition-therapeutic-implication.md), [Diagnostic Implications](StructureDefinition-diagnostic-implication.md), nor [Molecular Consequences](StructureDefinition-molecular-consequence.md). The intent of this profile is to provide a 'catch-all' mechanism for communicating existing or evolving annotations that don't fit nicely into other specific implication profiles.

Where the HL7 Clinical Genomics committee has identified specific use cases (e.g. for population allele frequency), this profile contains elements and/or extensions, along with examples, that enable a semantically consistent representation. For other use cases, one can apply new observation components and/or extensions as needed. In no case should one use this profile for use cases met by the DxImplication, TxImplication, or MolecularConsequence profiles.

### General usage notes

The genomic annotation profile can be used to annotate variants, haplotypes, genotypes, or molecular biomarkers with miscellaneous associations. For example, this profile can be used to assert the population allele frequency of a given variant.

Useful components include those that are broadly applicable to a number of annotations (e.g. component:knowledge-base), and those that are specific to a given type of annotation (e.g. component:population-allele-frequency):

* **component:evidence-level**: The amount of observed support for the association between an implication and a variant / haplotype / genotype / biomarker. (See the discussion of [evidence-level vs. clinical significance](StructureDefinition-implication.md#evidence-level-versus-clinical-significance) for additional guidance).
* **component:knowledge-base**: indicates the database from which the annotation is derived. Annotations are obtained from different knowledge bases (e.g. [Clinvar](https://www.ncbi.nlm.nih.gov/clinvar/), [gnomAD](https://gnomad.broadinstitute.org/), [1000 Genomes](https://www.internationalgenome.org/)). Knowledge bases continue to evolve, with new ones being developed, and existing ones being updated/revised.
* **component:annotation-pipeline**: indicates the name of the data pipeline that processed the genomic data file.
* **component:population-allele-frequency**: a specific type of annotation that indicates the prevalence of an allele in a population. This component can use the [knowledgebase-ancestry-group](StructureDefinition-knowledgebase-ancestry-group.md) extension to further characterize the applicable population.
* **component:conservation-score**: a specific type of annotation that indicates how much a specific DNA sequence or protein residue has remained unchanged across the evolutionary history of different species. High conservation scores indicate that a region is likely under strong selective pressure, meaning mutations in that region are detrimental to the organism's survival and reproduction. This component can use the [knowledgebase-ancestry-group](StructureDefinition-knowledgebase-ancestry-group.md) extension to further characterize the applicable population.
* **extension:knowledgebase-ancestry-group**: The [knowledgebase-ancestry-group](StructureDefinition-knowledgebase-ancestry-group.md) extension can be used to characterize the ancestry of the population from which a given annotation was derived. The extension is optional, and is considered unknown if not included. To indicate that an annotation is based on all assessed individuals, one can populate the extension with "ALL".

As with all implications, the explicit reference to the variant(s)/haplotype(s)/genotype(s)/molecular biomarker(s) being annotated must be provided in the Observation.derivedFrom field.

### evidence-level versus clinical-significance

See [Genomic Implication](StructureDefinition-implication.md#evidence-level-versus-clinical-significance) for guidance.

### Differentiating AND vs OR

See [Genomic Implication](StructureDefinition-implication.md#differentiating-and-vs-or) for guidance. Implication fields affected by this guidance include: derivedFrom, evidence-level, predicted-phenotype, genomic-risk-assessment.

**Usages:**

* Examples for this Profile: [Observation/pop-allele-freq](Observation-pop-allele-freq.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/genomic-annotation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-genomic-annotation.csv), [Excel](StructureDefinition-genomic-annotation.xlsx), [Schematron](StructureDefinition-genomic-annotation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "genomic-annotation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-annotation",
  "version" : "4.0.0-ballot",
  "name" : "GenomicAnnotation",
  "title" : "Genomic Annotation",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Profile for communicating miscellaneous genomic annotations that are neither Diagnostic Implications, Therapeutic Implications, nor Molecular Consequences.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.",
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/implication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Genomic Annotation"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "genomic-annotation",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "genomic-annotation"
            }
          ]
        }
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component"
      },
      {
        "id" : "Observation.component.extension:knowledgebase-ancestry-group",
        "path" : "Observation.component.extension",
        "sliceName" : "knowledgebase-ancestry-group",
        "requirements" : "This SHOULD be used to identify the sample ancestry group according to the referenced knowledgebase",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/knowledgebase-ancestry-group"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:population-allele-frequency",
        "path" : "Observation.component",
        "sliceName" : "population-allele-frequency",
        "short" : "Population Allele Frequency",
        "definition" : "The observed rate of appearance a frequency has in a given sample population",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:population-allele-frequency.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:population-allele-frequency.extension:knowledgebase-ancestry-group",
        "path" : "Observation.component.extension",
        "sliceName" : "knowledgebase-ancestry-group",
        "requirements" : "This SHOULD be used to identify the sample ancestry group according to the referenced knowledgebase",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/knowledgebase-ancestry-group"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:population-allele-frequency.code",
        "path" : "Observation.component.code",
        "short" : "population-allele-frequency",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "92821-8"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:population-allele-frequency.value[x]",
        "path" : "Observation.component.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.component:conservation-score",
        "path" : "Observation.component",
        "sliceName" : "conservation-score",
        "short" : "conservation score",
        "definition" : "The measure of evolutionary conservation at an individual alignment site",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:conservation-score.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:conservation-score.extension:knowledgebase-ancestry-group",
        "path" : "Observation.component.extension",
        "sliceName" : "knowledgebase-ancestry-group",
        "requirements" : "This SHOULD be used to identify the sample ancestry group according to the referenced knowledgebase",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/knowledgebase-ancestry-group"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:conservation-score.code",
        "path" : "Observation.component.code",
        "short" : "conservation-score",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "conservation-score"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:conservation-score.value[x]",
        "path" : "Observation.component.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      }
    ]
  }
}

```
