# Coded Annotation - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Coded Annotation**

## Data Type Profile: Coded Annotation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/coded-annotation | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CodedAnnotation |

 
Annotation DataType with added CodeableConcept extension element 

This profile adds a CodeableConcept extension to the Annotation data type. The Annotation data type is meant to capture text notes plus information about who made the statement and when. This new extension gives a coded meaning (e.g. test disclaimer, tumor board preparation note) to the notes. Many notes will not require this code, so this extension is optional. It can be used when implementers feel the meaning is important.

If there is a possibility of transporting the content of the note in a structured manner the usage of CodedAnnotation is forbidden and the corresponding data structures SHALL be used. For example, if the text to send resembles the interpretation or impression of the Observation, this guide adds `Observation.component` slice for `[conclusion-string](StructureDefinition-genomic-base-definitions.html#Observation.component:conclusion-string)` which is more appropriate than a note. This would include text like interpretative information (typically canned) about a variant identified in the patient. This slice is defined in the [Genomic Base](StructureDefinition-genomic-base.md) profile, which every observation builds upon. Therefore, this component is a defined slice on all observations profiles defined in this Implementation Guide.

**Usages:**

* Use this DataType Profile: [Genomic Base](StructureDefinition-genomic-base.md) and [Genomic Report Note](StructureDefinition-genomic-report-note.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/coded-annotation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-coded-annotation.csv), [Excel](StructureDefinition-coded-annotation.xlsx), [Schematron](StructureDefinition-coded-annotation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "coded-annotation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "has-size"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/coded-annotation",
  "version" : "4.0.0-ballot",
  "name" : "CodedAnnotation",
  "title" : "Coded Annotation",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Annotation DataType with added CodeableConcept extension element",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Annotation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Annotation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Annotation",
        "path" : "Annotation"
      },
      {
        "id" : "Annotation.extension:code",
        "path" : "Annotation.extension",
        "sliceName" : "code",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/annotation-code"
            ]
          }
        ]
      }
    ]
  }
}

```
