# normalSpecimen - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **normalSpecimen**

## Example Specimen: normalSpecimen

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**identifier**: `http://example.org/identifiers/specimens`/444555

**status**: Available

**type**: Blood specimen (specimen)

**subject**: [Hamsburg, Substance Jr](Patient-somaticPatient.md)

**receivedTime**: 2023-01-23 01:01:01+0000

### Collections

| | |
| :--- | :--- |
| - | **Collected[x]** |
| * | 2023-01-01 01:01:00+0000 |



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "normalSpecimen",
  "identifier" : [
    {
      "system" : "http://example.org/identifiers/specimens",
      "value" : "444555"
    }
  ],
  "status" : "available",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "119297000",
        "display" : "Blood specimen (specimen)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/somaticPatient",
    "display" : "Hamsburg, Substance Jr"
  },
  "receivedTime" : "2023-01-23T01:01:01Z",
  "collection" : {
    "collectedDateTime" : "2023-01-01T01:01:00Z"
  }
}

```
