# genomicSpecimen - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **genomicSpecimen**

## Example Specimen: genomicSpecimen

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**identifier**: `http://example.org/identifiers/specimens`/4

**status**: Available

**type**: Specimen from lung obtained by biopsy (specimen)

**subject**: [John Doe](Patient-genomicPatient.md)

**receivedTime**: 2019-03-01 01:01:01+0000

**request**: [ServiceRequest Molecular genetic test (procedure)](ServiceRequest-genomicServiceRequest.md)

### Collections

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Collector** | **Collected[x]** | **Quantity** | **Method** |
| * | [Practitioner Jane Doel](Practitioner-practitioner02.md) | 2019-03-01 01:01:00+0000 | 1 mm2 | Biopsy - action |



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "genomicSpecimen",
  "identifier" : [
    {
      "system" : "http://example.org/identifiers/specimens",
      "value" : "4"
    }
  ],
  "status" : "available",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "122610009",
        "display" : "Specimen from lung obtained by biopsy (specimen)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/genomicPatient",
    "display" : "John Doe"
  },
  "receivedTime" : "2019-03-01T01:01:01Z",
  "request" : [
    {
      "reference" : "ServiceRequest/genomicServiceRequest"
    }
  ],
  "collection" : {
    "collector" : {
      "reference" : "Practitioner/practitioner02"
    },
    "collectedDateTime" : "2019-03-01T01:01:00Z",
    "quantity" : {
      "value" : 1,
      "unit" : "mm2"
    },
    "method" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "129314006",
          "display" : "Biopsy - action"
        }
      ]
    }
  }
}

```
