# GenomicSpecimenExample02 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **GenomicSpecimenExample02**

## Example Specimen: GenomicSpecimenExample02

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**identifier**: `http://example.org`/123

**accessionIdentifier**: `http://example.org`/456

**status**: Available

**type**: Buccal smear sample

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

### Processings

| | |
| :--- | :--- |
| - | **Time[x]** |
| * | 2020-10-05 |



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "GenomicSpecimenExample02",
  "identifier" : [
    {
      "system" : "http://example.org",
      "value" : "123"
    }
  ],
  "accessionIdentifier" : {
    "system" : "http://example.org",
    "value" : "456"
  },
  "status" : "available",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "258564008",
        "display" : "Buccal smear sample"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "processing" : [
    {
      "timeDateTime" : "2020-10-05"
    }
  ]
}

```
