# somaticServiceRequest - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **somaticServiceRequest**

## Example ServiceRequest: somaticServiceRequest

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**identifier**: Laboratory Accession ID/1111jh11112

**status**: Active

**intent**: Plan

### Codes

| | |
| :--- | :--- |
| - | **Concept** |
| * | My Test Cancer 700 Gene Panel |

**subject**: [Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-somaticPatient.md)

**requester**: [Practitioner Test Submitter](Practitioner-orderingPractitioner.md)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Adenocarcinoma of lung, stage IV (disorder) |



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "somaticServiceRequest",
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "LACSN"
          }
        ],
        "text" : "Laboratory Accession ID"
      },
      "system" : "http://example.org/identifiers/serviceRequests",
      "value" : "1111jh11112"
    }
  ],
  "status" : "active",
  "intent" : "plan",
  "code" : {
    "concept" : {
      "text" : "My Test Cancer 700 Gene Panel"
    }
  },
  "subject" : {
    "reference" : "Patient/somaticPatient"
  },
  "requester" : {
    "reference" : "Practitioner/orderingPractitioner"
  },
  "reason" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "424993006",
            "display" : "Adenocarcinoma of lung, stage IV (disorder)"
          }
        ]
      }
    }
  ]
}

```
