# FindSubjectVariantsOutput - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **FindSubjectVariantsOutput**

## Example Parameters: FindSubjectVariantsOutput

## Parameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "FindSubjectVariantsOutput",
  "parameter" : [
    {
      "name" : "variants",
      "part" : [
        {
          "name" : "rangeItem",
          "valueString" : "NC_000017.11:39688093-39728660"
        },
        {
          "name" : "presence",
          "valueBoolean" : false
        }
      ]
    },
    {
      "name" : "variants",
      "part" : [
        {
          "name" : "rangeItem",
          "valueString" : "NC_000007.14:140713327-140924929"
        },
        {
          "name" : "presence",
          "valueBoolean" : true
        },
        {
          "name" : "variant",
          "resource" : {
            "resourceType" : "Observation",
            "id" : "dv-5a7f781e83514",
            "meta" : {
              "profile" : [
                "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Variant</div>"
            },
            "status" : "final",
            "category" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                    "code" : "laboratory"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                    "code" : "GE"
                  }
                ]
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69548-6",
                  "display" : "Genetic variant assessment"
                }
              ]
            },
            "subject" : {
              "reference" : "Patient/HG00403"
            },
            "effectiveDateTime" : "2023-07-01",
            "performer" : [
              {
                "reference" : "Organization/ExampleOrg"
              }
            ],
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA9633-4",
                  "display" : "Present"
                }
              ]
            },
            "component" : [
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "48002-0",
                      "display" : "Genomic source class [Type]"
                    }
                  ]
                },
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "LA6684-0",
                      "display" : "Somatic"
                    }
                  ]
                }
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "48013-7",
                      "display" : "Genomic reference sequence ID"
                    }
                  ]
                },
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                      "code" : "NC_000007.14"
                    }
                  ]
                }
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "81258-6",
                      "display" : "Sample VAF"
                    }
                  ]
                },
                "valueQuantity" : {
                  "value" : 0.1793,
                  "unit" : "relative frequency of a particular allele in the specimen",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "1"
                }
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "69547-8",
                      "display" : "Genomic Ref allele [ID]"
                    }
                  ]
                },
                "valueString" : "A"
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "69551-0",
                      "display" : "Genomic Alt allele [ID]"
                    }
                  ]
                },
                "valueString" : "T"
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "92822-6",
                      "display" : "Genomic coord system"
                    }
                  ]
                },
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "LA30100-4",
                      "display" : "0-based interval counting"
                    }
                  ]
                }
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "81254-5"
                    }
                  ],
                  "text" : "Genomic allele start-end"
                },
                "valueRange" : {
                  "low" : {
                    "value" : 140753335
                  }
                }
              }
            ]
          }
        }
      ]
    }
  ]
}

```
