# FindSubjectTxImplicationsOutput - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **FindSubjectTxImplicationsOutput**

## Example Parameters: FindSubjectTxImplicationsOutput

## Parameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "FindSubjectTxImplicationsOutput",
  "parameter" : [
    {
      "name" : "implication",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "TherapeuticImplicationExample",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Therapeutic Implication</div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "therapeutic-implication"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/HG00403"
        },
        "effectiveDateTime" : "2023-07-01",
        "performer" : [
          {
            "reference" : "Organization/ExampleOrg"
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/VariantExample"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "therapeutic-implication"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6677-4",
                  "display" : "Responsive"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51963-7",
                  "display" : "Medication assessed"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
                  "code" : "480167",
                  "display" : "Lapatinib"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "name" : "variant",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "variantExample",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Variant</div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/HG00403"
        },
        "effectiveDateTime" : "2023-07-01",
        "performer" : [
          {
            "reference" : "Organization/ExampleOrg"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class [Type]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48013-7",
                  "display" : "Genomic reference sequence ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NC_000017.11"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic Ref allele [ID]"
                }
              ]
            },
            "valueString" : "ATTGAGGGAAAACACAT"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69551-0",
                  "display" : "Genomic Alt allele [ID]"
                }
              ]
            },
            "valueString" : "T"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "92822-6",
                  "display" : "Genomic coord system"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA30100-4",
                  "display" : "0-based interval counting"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81254-5"
                }
              ],
              "text" : "Genomic allele start-end"
            },
            "valueRange" : {
              "low" : {
                "value" : 39723965
              }
            }
          }
        ]
      }
    }
  ]
}

```
