# FindSubjectMolecConseqOutput - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **FindSubjectMolecConseqOutput**

## Example Parameters: FindSubjectMolecConseqOutput

## Parameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "FindSubjectMolecConseqOutput",
  "parameter" : [
    {
      "name" : "consequence",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "MC1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">NM_001395525.1:c.-281+2T&gt;C - intronic_variant:loss_of_function_variant</div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "molecular-consequence"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/HG00403"
        },
        "effectiveDateTime" : "2023-04-01",
        "performer" : [
          {
            "reference" : "Organization/ExampleOrg"
          }
        ],
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://example.org/pcingola.github.io/SnpEff/se_inputoutput/#impact-prediction",
                "code" : "HIGH",
                "display" : "High"
              }
            ]
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/variantExampleMC"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_001395525.1",
                  "display" : "NM_001395525.1"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "feature-consequence"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:0001575",
                  "display" : "splice_donor_variant"
                },
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:0001627",
                  "display" : "intron_variant"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "functional-effect"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO_0002054",
                  "display" : "loss_of_function_variant"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "name" : "consequence",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "MC2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">NM_001366781.1:c.90T&gt;C - synonymous_variant</div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "molecular-consequence"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/HG00403"
        },
        "effectiveDateTime" : "2023-04-01",
        "performer" : [
          {
            "reference" : "Organization/ExampleOrg"
          }
        ],
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://example.org/pcingola.github.io/SnpEff/se_inputoutput/#impact-prediction",
                "code" : "LOW",
                "display" : "Low"
              }
            ]
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/variantExampleMC"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6"
                }
              ],
              "text" : "coding HGVS"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_001366781.1:c.90T>C",
                  "display" : "NM_001366781.1:c.90T>C"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_001366781.1",
                  "display" : "NM_001366781.1"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "feature-consequence"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:0001819",
                  "display" : "synonymous_variant"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "name" : "consequence",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "MC3",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Molecular Consequence</div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "molecular-consequence"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/HG00403"
        },
        "effectiveDateTime" : "2023-04-01",
        "performer" : [
          {
            "reference" : "Organization/ExampleOrg"
          }
        ],
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://example.org/pcingola.github.io/SnpEff/se_inputoutput/#impact-prediction",
                "code" : "MOD",
                "display" : "Modifier"
              }
            ]
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/variantExampleMC"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6"
                }
              ],
              "text" : "coding HGVS"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_001395543.1:c.-171T>C",
                  "display" : "NM_001395543.1:c.-171T>C"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_001395543.1",
                  "display" : "NM_001395543.1"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "feature-consequence"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:0001623",
                  "display" : "5_prime_UTR_variant"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "name" : "consequence",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "MC4",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Molecular Consequence</div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "molecular-consequence"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/HG00403"
        },
        "effectiveDateTime" : "2023-04-01",
        "performer" : [
          {
            "reference" : "Organization/ExampleOrg"
          }
        ],
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://example.org/pcingola.github.io/SnpEff/se_inputoutput/#impact-prediction",
                "code" : "MOD",
                "display" : "Modifier"
              }
            ]
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/variantExampleMC"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_001395544.1",
                  "display" : "NM_001395544.1"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "feature-consequence"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:0001627",
                  "display" : "intron_variant"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "name" : "variant",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "variantExampleMC",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Variant</div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/HG00403"
        },
        "effectiveDateTime" : "2023-04-01",
        "performer" : [
          {
            "reference" : "Organization/ExampleOrg"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6683-2",
                  "display" : "Germline"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48013-7",
                  "display" : "Genomic reference sequence ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NC_000001.10"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "53034-5",
                  "display" : "Allelic state"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6706-1",
                  "display" : "Heterozygous"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81252-9",
                  "display" : "Discrete genetic variant"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NC_000001.10:g.86852621A>G",
                  "display" : "NC_000001.10:g.86852621A>G"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.6,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic Ref allele [ID]"
                }
              ]
            },
            "valueString" : "A"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69551-0",
                  "display" : "Genomic Alt allele [ID]"
                }
              ]
            },
            "valueString" : "G"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "92822-6",
                  "display" : "Genomic coord system"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA30100-4",
                  "display" : "0-based interval counting"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81254-5",
                  "display" : "Genomic allele start-end"
                }
              ]
            },
            "valueRange" : {
              "low" : {
                "value" : 86852620
              }
            }
          }
        ]
      }
    }
  ]
}

```
