# FindSubjectDxImplicationsOutput - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **FindSubjectDxImplicationsOutput**

## Example Parameters: FindSubjectDxImplicationsOutput

## Parameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "FindSubjectDxImplicationsOutput",
  "parameter" : [
    {
      "name" : "implication",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "DiagnosticImplicationExample",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Pathogenic - Malignant hyperthermia</div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "diagnostic-implication"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/HG00403"
        },
        "effectiveDateTime" : "2023-04-01",
        "performer" : [
          {
            "reference" : "Organization/ExampleOrg"
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/VariantExample2"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "53037-8"
                }
              ],
              "text" : "Genetic variation clinical significance"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6668-3",
                  "display" : "Pathogenic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81259-4"
                }
              ],
              "text" : "Predicted phenotype"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "405501007",
                  "display" : "Malignant hyperthermia"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "name" : "variant",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "variantExample2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">NC_000019.10:g.38499669C&gt;T</div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/HG00403"
        },
        "effectiveDateTime" : "2023-04-01",
        "performer" : [
          {
            "reference" : "Organization/ExampleOrg"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class [Type]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6683-2",
                  "display" : "Germline"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48013-7",
                  "display" : "Genomic reference sequence ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NC_000019.10"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic Ref allele [ID]"
                }
              ]
            },
            "valueString" : "C"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69551-0",
                  "display" : "Genomic Alt allele [ID]"
                }
              ]
            },
            "valueString" : "T"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "92822-6",
                  "display" : "Genomic coord system"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA30100-4",
                  "display" : "0-based interval counting"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81254-5"
                }
              ],
              "text" : "Genomic allele start-end"
            },
            "valueRange" : {
              "low" : {
                "value" : 38499669
              }
            }
          }
        ]
      }
    }
  ]
}

```
