# Find Subject Treatment Implications - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Find Subject Treatment Implications**

## OperationDefinition: Find Subject Treatment Implications 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-subject-tx-implications | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:FindSubjectTxImplications |

 
Retrieves genetic therapeutic implications for variants/haplotypes/genotypes. 

### Description

Retrieves genetic therapeutic implications for variants/haplotypes/genotypes.

Therapeutic implications cover a wide range of scenarios - from pharmacogenomics (e.g. a patient's genotype may be associated with altered metabolism of a specific drug) to cancer care (e.g. a patient's somatic variant may be associated with response to a specific drug and/or with eligibility for a specific clinical trial).

For pharmacogenomics, generally the operation will be called with 'subject' and 'haplotypes' parameters, which will return implications reflecting those drugs whose efficacy or safety are altered based on the patient haplotypes. Including the 'treatments' parameter will limit the return to implications for the supplied drugs. For cancer care, generally the operation will be called with 'subject' and 'ranges' parameters, which will return therapeutic implications for patient variants in supplied ranges. Including the 'conditions' parameter will limit the return to implications specific to the supplied conditions. Including the 'treatments' parameter will limit the return to implications for the supplied drugs. These parameter combinations enable, for instance, queries that check to see if a patient has any therapeutic options for somatic variants, specifically for their tumor type. For other combinations of input parameters, the operation returns therapeutic implications satisfying all parameters.

Where no variants, ranges, haplotypes, treatments, or conditions are provided, the operation returns no implications.

As shown in the following picture, this operation can return previously instantiated implications and/or dynamically computed implications. Specific implementations can indicate their capabilities using a [FHIR Capability Statement](https://www.hl7.org/fhir/capabilitystatement.html). Rules around the retention of dynamically computed implications are outside the scope of this operation, but a server could potentially instantiate those results based on the [Therapeutic Implication](StructureDefinition-therapeutic-implication.md), [Diagnostic Implication](StructureDefinition-diagnostic-implication.md), or [Molecular Consequence](StructureDefinition-molecular-consequence.md) FHIR profiles.

Dynamic computation of implications can return a large number of results (e.g. 'find therapeutic implications for cancer'). Results can be curtailed using additional operation parameters (e.g. 'find therapeutic implications for somatic variant NM_007294.4:c.5578del in breast cancer").

### Parameters

* **Use**: IN
  * **Name**: subject
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([reference](https://hl7.org/fhir/R5/search.html#reference))
  * **Binding**: 
  * **Documentation**: The subject of interest.
* **Use**: IN
  * **Name**: variants
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([string](https://hl7.org/fhir/R5/search.html#string))
  * **Binding**: 
  * **Documentation**: List of variants from which implications are derived. Must be in HGVS or SPDI format.
* **Use**: IN
  * **Name**: ranges
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([special](https://hl7.org/fhir/R5/search.html#special))
  * **Binding**: 
  * **Documentation**: List of regions to be searched for variants. Must be in zero-based RefSeq:Integer-range format (e.g. 'NC_000007.14:55174721-55174820').
* **Use**: IN
  * **Name**: haplotypes
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: List of haplotypes and/or genotypes from which implications are derived. Must be in token or codesystem|code format.
* **Use**: IN
  * **Name**: treatments
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: List of medications and/or other therapeutic interventions for which implications are sought. Must be in token or codesystem|code format.
* **Use**: IN
  * **Name**: conditions
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: List of conditions for which implications are sought. Must be in token or codesystem|code format.
* **Use**: IN
  * **Name**: testIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Supply a list of test identifiers. Only results originating from one of these tests will be returned.
* **Use**: IN
  * **Name**: testDateRange
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Period](http://hl7.org/fhir/R5/datatypes.html#Period)
  * **Binding**: 
  * **Documentation**: Supply a date range. Only results generated during this range will be returned.
* **Use**: IN
  * **Name**: specimenIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Supply a list of specimen identifiers. Only results derived from one of these specimens will be returned.
* **Use**: IN
  * **Name**: genomicSourceClass
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.
* **Use**: OUT
  * **Name**: implication
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Observation](http://hl7.org/fhir/R5/observation.html)
  * **Binding**: 
  * **Documentation**: Implications must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication]. The target(s) of the implication's derivedFrom shall also be included in the response.
* **Use**: OUT
  * **Name**: variant
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Observation](http://hl7.org/fhir/R5/observation.html)
  * **Binding**: 
  * **Documentation**: Variants must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant].
* **Use**: OUT
  * **Name**: haplotype
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Observation](http://hl7.org/fhir/R5/observation.html)
  * **Binding**: 
  * **Documentation**: Haplotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype].
* **Use**: OUT
  * **Name**: genotype
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Observation](http://hl7.org/fhir/R5/observation.html)
  * **Binding**: 
  * **Documentation**: Genotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype].

### Notes:

#### Error Codes

Valid response codes are shown in the following table. Additional response codes (e.g. 5xx server error) may also be encountered.

| | |
| :--- | :--- |
| 200 | Successfully executed request |
| 400 | ERROR: Invalid query parameters |
| 404 | ERROR: Patient not found |
| 422 | ERROR: Failed[LiftOver](operations.md#liftover) |

#### Examples

Clinician seeks to determine if their patient has any potential drug-gene interactions based on the presence of their patient's CYP2C19 **1/**2 genotype.

```
$find-subject-tx-implications?subject=HG00403&haplotypes=CYP2C19 *1/*2

```

Clinician is considering the use of clopidogrel, and seeks to determine if their patient has any potential drug-gene interactions that might affect clopidogrel efficacy.

```
$find-subject-tx-implications?subject=HG00403&treatments=http://www.nlm.nih.gov/research/umls/rxnorm|32968

```

Clinician is considering treatment options for a 66 year old non-smoker recently diagnosed with metastatic non-small cell lung cancer. The clinician wants to see if patient has any NSCLC-specific druggable targets in ALK (NC_000002.12:29190991-29921589), BRAF (NC_000007.14:140713327-140924929), or EGFR (NC_000007.14:55019016-55211628).

```
$find-subject-tx-implications?subject=HG00403&ranges=NC_000002.12:29190991-29921589,NC_000007.14:140713327-140924929,NC_000007.14:55019016-55211628&conditions=http://www.sequenceontology.org|3908

```

This query seeks to determine if the subject has any breast cancer-specific therapeutic implications (e.g. medications, clinical trials) based on identified somatic variants in recent specimen.

```
$find-subject-tx-implications?subject=HG00403&conditions=http://snomed.info/sct|372137005&genomicSourceClass=somatic&specimenIdentfiers=1

```

This query seeks to determine if the subject has any genetic findings that have implications for inclusion in clinical trial NCT01234567.

```
$find-subject-tx-implications?subject=HG00403&treatments=https://clinicaltrials.gov/|NCT01234567

```

Patient HG00403 has metastatic breast cancer. Targeted sequencing of a tumor biopsy specimen shows ERBB2 (HER2) variant NM_004448.4:c.2264_2278del. What are the treatment implications for this patient? (Results indicate responsiveness to lapatinib).

```

GET .../$find-subject-tx-implications?subject=HG00403&variants=NM_004448.4:c.2264_2278del&conditions=http://snomed.info/sct|372137005

```

See [example output](Parameters-FindSubjectTxImplicationsOutput.md).



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "find-subject-tx-implications",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-subject-tx-implications",
  "version" : "4.0.0-ballot",
  "name" : "FindSubjectTxImplications",
  "title" : "Find Subject Treatment Implications",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Retrieves genetic therapeutic implications for variants/haplotypes/genotypes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "code" : "match",
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "subject",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The subject of interest.",
      "type" : "string",
      "searchType" : "reference"
    },
    {
      "name" : "variants",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of variants from which implications are derived. Must be in HGVS or SPDI format.",
      "type" : "string",
      "searchType" : "string"
    },
    {
      "name" : "ranges",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of regions to be searched for variants. Must be in zero-based RefSeq:Integer-range format (e.g. 'NC_000007.14:55174721-55174820').",
      "type" : "string",
      "searchType" : "special"
    },
    {
      "name" : "haplotypes",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of haplotypes and/or genotypes from which implications are derived. Must be in token or codesystem|code format.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "treatments",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of medications and/or other therapeutic interventions for which implications are sought. Must be in token or codesystem|code format.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "conditions",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of conditions for which implications are sought. Must be in token or codesystem|code format.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "testIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "Supply a list of test identifiers. Only results originating from one of these tests will be returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "testDateRange",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Supply a date range. Only results generated during this range will be returned.",
      "type" : "Period"
    },
    {
      "name" : "specimenIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "Supply a list of specimen identifiers. Only results derived from one of these specimens will be returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "genomicSourceClass",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile",
          "valueUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        }
      ],
      "name" : "implication",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "documentation" : "Implications must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication]. The target(s) of the implication's derivedFrom shall also be included in the response.",
      "type" : "Observation"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile",
          "valueUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        }
      ],
      "name" : "variant",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "documentation" : "Variants must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant].",
      "type" : "Observation"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile",
          "valueUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        }
      ],
      "name" : "haplotype",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "documentation" : "Haplotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype].",
      "type" : "Observation"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile",
          "valueUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
        }
      ],
      "name" : "genotype",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "documentation" : "Genotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype].",
      "type" : "Observation"
    }
  ]
}

```
