# Find Subject Specific Variants - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Find Subject Specific Variants**

## OperationDefinition: Find Subject Specific Variants 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-subject-specific-variants | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:FindSubjectSpecificVariants |

 
Determine if specified simple variants are present. 

### Description

Determine if specified simple variants are present or not. If any specified variant instance that passes the filters is present, then presence=true, else presence=false. (See section '[Simple vs. Structural variant operations](operations.md#simple-structural)' for the distinction between simple and structural variants).

### Parameters

* **Use**: IN
  * **Name**: subject
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([reference](https://hl7.org/fhir/R5/search.html#reference))
  * **Binding**: 
  * **Documentation**: The subject of interest.
* **Use**: IN
  * **Name**: variants
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([string](https://hl7.org/fhir/R5/search.html#string))
  * **Binding**: 
  * **Documentation**: List of variants being sought. Must be in HGVS or SPDI format.
* **Use**: IN
  * **Name**: testIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Supply a list of test identifiers. Only results originating from one of these tests will be returned.
* **Use**: IN
  * **Name**: testDateRange
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Period](http://hl7.org/fhir/R5/datatypes.html#Period)
  * **Binding**: 
  * **Documentation**: Supply a date range. Only results generated during this range will be returned.
* **Use**: IN
  * **Name**: specimenIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Supply a list of specimen identifiers. Only results derived from one of these specimens will be returned.
* **Use**: IN
  * **Name**: genomicSourceClass
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.
* **Use**: OUT
  * **Name**: variants
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: 
  * **Binding**: 
  * **Documentation**: (one for each variant in variantList)
* **Use**: OUT
  * **Name**: variants.variantItem
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: variant from variantList
* **Use**: OUT
  * **Name**: variants.presence
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [boolean](http://hl7.org/fhir/R5/datatypes.html#boolean)
  * **Binding**: 
  * **Documentation**: 
* **Use**: OUT
  * **Name**: variants.variant
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Observation](http://hl7.org/fhir/R5/observation.html)
  * **Binding**: 
  * **Documentation**: Variants must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant] and minimally include valueCodeableConcept; component:genomic-ref-seq; component:ref-allele; component:alt-allele; component:coordinate-system (valued with '0-based interval counting'); component:exact-start-end.

### Notes:

#### Error Codes

Valid response codes are shown in the following table. Additional response codes (e.g. 5xx server error) may also be encountered.

| | |
| :--- | :--- |
| 200 | Successfully executed request |
| 400 | ERROR: Invalid query parameters |
| 404 | ERROR: Patient not found |
| 422 | ERROR: Failed[LiftOver](operations.md#liftover) |

#### Examples

See if patient HG00403 had any of these [NM_001354609.2:c.1799T>A, NM_007294.4:c.5559C>A, NC_000001.10:g.12225351T>A, NM_000038.6:c.55G>T, NM_001354609.2:c.1802=] germline variants detected by test1 or test2.

```

GET .../$find-subject-specific-variants?subject=HG00403&variants=NM_001354609.2:c.1799T>A,NM_007294.4:c.5559C>A,NC_000001.10:g.12225351T>A,NM_000038.6:c.55G>T,NM_001354609.2:c.1802=&testIdentifiers=test1,test2&genomicSourceClass=germline

```

See [example output](Parameters-FindSubjectSpecificVariantsOutput.md).



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "find-subject-specific-variants",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-subject-specific-variants",
  "version" : "4.0.0-ballot",
  "name" : "FindSubjectSpecificVariants",
  "title" : "Find Subject Specific Variants",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Determine if specified simple variants are present.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "code" : "match",
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "subject",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The subject of interest.",
      "type" : "string",
      "searchType" : "reference"
    },
    {
      "name" : "variants",
      "use" : "in",
      "min" : 1,
      "max" : "*",
      "documentation" : "List of variants being sought. Must be in HGVS or SPDI format.",
      "type" : "string",
      "searchType" : "string"
    },
    {
      "name" : "testIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "Supply a list of test identifiers. Only results originating from one of these tests will be returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "testDateRange",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Supply a date range. Only results generated during this range will be returned.",
      "type" : "Period"
    },
    {
      "name" : "specimenIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "Supply a list of specimen identifiers. Only results derived from one of these specimens will be returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "genomicSourceClass",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "variants",
      "use" : "out",
      "min" : 1,
      "max" : "*",
      "documentation" : "(one for each variant in variantList)",
      "part" : [
        {
          "name" : "variantItem",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "variant from variantList",
          "type" : "string"
        },
        {
          "name" : "presence",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile",
              "valueUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
            }
          ],
          "name" : "variant",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "documentation" : "Variants must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant] and minimally include valueCodeableConcept; component:genomic-ref-seq; component:ref-allele; component:alt-allele; component:coordinate-system (valued with '0-based interval counting'); component:exact-start-end.",
          "type" : "Observation"
        }
      ]
    }
  ]
}

```
