# Find Subject Molecular Consequences - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Find Subject Molecular Consequences**

## OperationDefinition: Find Subject Molecular Consequences 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-subject-molecular-consequences | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:FindSubjectMolecularConsequences |

 
Retrieves molecular consequences of a DNA variant. 

### Description

Retrieves molecular consequences of a DNA variant.

Generally, the operation will be called with 'subject' and 'ranges' parameters, which will return molecular consequences for patient variants in supplied ranges. Another common pattern is to call the operation with 'subject', 'ranges', and 'featureConsequences' parameters, which will limit the return to only those molecular consequences having supplied features. For other combinations of input parameters, the operation returns molecular consequences satisfying all parameters.

Where no variants, ranges, or featureConsequences are provided, the operation returns no consequences.

As shown in the following picture, this operation can return previously instantiated implications and/or dynamically computed implications. Specific implementations can indicate their capabilities using a [FHIR Capability Statement](https://www.hl7.org/fhir/capabilitystatement.html). Rules around the retention of dynamically computed implications are outside the scope of this operation, but a server could potentially instantiate those results based on the [Therapeutic Implication](StructureDefinition-therapeutic-implication.md), [Diagnostic Implication](StructureDefinition-diagnostic-implication.md), or [Molecular Consequence](StructureDefinition-molecular-consequence.md) FHIR profiles.

### Parameters

* **Use**: IN
  * **Name**: subject
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([reference](https://hl7.org/fhir/R5/search.html#reference))
  * **Binding**: 
  * **Documentation**: The subject of interest.
* **Use**: IN
  * **Name**: variants
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([string](https://hl7.org/fhir/R5/search.html#string))
  * **Binding**: 
  * **Documentation**: List of variants from which consequences are derived. Must be in HGVS or SPDI format.
* **Use**: IN
  * **Name**: ranges
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([special](https://hl7.org/fhir/R5/search.html#special))
  * **Binding**: 
  * **Documentation**: List of regions to be searched for variants. Must be in zero-based RefSeq:Integer-range format (e.g. 'NC_000007.14:55174721-55174820').
* **Use**: IN
  * **Name**: featureConsequences
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: List of consequences sought. Must be in token or codesystem|code format. (These will generally be coded with Sequence Ontology codes under SO:0001537)
* **Use**: IN
  * **Name**: testIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Supply a list of test identifiers. Only results originating from one of these tests will be returned.
* **Use**: IN
  * **Name**: testDateRange
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Period](http://hl7.org/fhir/R5/datatypes.html#Period)
  * **Binding**: 
  * **Documentation**: Supply a date range. Only results generated during this range will be returned.
* **Use**: IN
  * **Name**: specimenIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Supply a list of specimen identifiers. Only results derived from one of these specimens will be returned.
* **Use**: IN
  * **Name**: genomicSourceClass
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.
* **Use**: OUT
  * **Name**: consequence
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Observation](http://hl7.org/fhir/R5/observation.html)
  * **Binding**: 
  * **Documentation**: Consequences must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence]. The target(s) of the consequence's derivedFrom shall also be included in the response.
* **Use**: OUT
  * **Name**: variant
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Observation](http://hl7.org/fhir/R5/observation.html)
  * **Binding**: 
  * **Documentation**: Variants must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant].

### Notes:

#### Error Codes

Valid response codes are shown in the following table. Additional response codes (e.g. 5xx server error) may also be encountered.

| | |
| :--- | :--- |
| 200 | Successfully executed request |
| 400 | ERROR: Invalid query parameters |
| 404 | ERROR: Patient not found |
| 422 | ERROR: Failed[LiftOver](operations.md#liftover) |

#### Examples

A patient with lung cancer has no known druggable targets. Their clinician wants to see if any variants in ALK (NC_000002.12:29190991-29921589), BRAF (NC_000007.14:140713327-140924929), or EGFR (NC_000007.14:55019016-55211628) are predicted to be consequential.

```
$find-subject-molecular-consequences?subject=HG00403&ranges=NC_000002.12:29190991-29921589,NC_000007.14:140713327-140924929,NC_000007.14:55019016-55211628

```

The clinician wants to further constrain the query in the prior example to only return variants predicted to affect splice donor sites

```
$find-subject-molecular-consequences?subject=HG00403&ranges=NC_000002.12:29190991-29921589,NC_000007.14:140713327-140924929,NC_000007.14:55019016-55211628&featureConsequences=http://www.sequenceontology.org|SO:0001575

```

Patient HG00403 is detected as having a variant (NC_000001.10:86852620:A:G) in the ODF2L gene, and their clinician wants to further characterize the variant by examining its predicted molecular consequences. (Results indicate that the variant affects a splice donor site and can lead to gene loss of function).

```

GET .../$find-subject-molecular-consequences?subject=HG00403&variants=NC_000001.10:86852620:A:G

```

See [example output](Parameters-FindSubjectMolecConseqOutput.md).



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "find-subject-molecular-consequences",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-subject-molecular-consequences",
  "version" : "4.0.0-ballot",
  "name" : "FindSubjectMolecularConsequences",
  "title" : "Find Subject Molecular Consequences",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Retrieves molecular consequences of a DNA variant.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "code" : "match",
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "subject",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The subject of interest.",
      "type" : "string",
      "searchType" : "reference"
    },
    {
      "name" : "variants",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of variants from which consequences are derived. Must be in HGVS or SPDI format.",
      "type" : "string",
      "searchType" : "string"
    },
    {
      "name" : "ranges",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of regions to be searched for variants. Must be in zero-based RefSeq:Integer-range format (e.g. 'NC_000007.14:55174721-55174820').",
      "type" : "string",
      "searchType" : "special"
    },
    {
      "name" : "featureConsequences",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of consequences sought. Must be in token or codesystem|code format. (These will generally be coded with Sequence Ontology codes under SO:0001537)",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "testIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "Supply a list of test identifiers. Only results originating from one of these tests will be returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "testDateRange",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Supply a date range. Only results generated during this range will be returned.",
      "type" : "Period"
    },
    {
      "name" : "specimenIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "Supply a list of specimen identifiers. Only results derived from one of these specimens will be returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "genomicSourceClass",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile",
          "valueUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        }
      ],
      "name" : "consequence",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "documentation" : "Consequences must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence]. The target(s) of the consequence's derivedFrom shall also be included in the response.",
      "type" : "Observation"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile",
          "valueUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        }
      ],
      "name" : "variant",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "documentation" : "Variants must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant].",
      "type" : "Observation"
    }
  ]
}

```
