# Find Population Specific Haplotypes - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Find Population Specific Haplotypes**

## OperationDefinition: Find Population Specific Haplotypes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-population-specific-haplotypes | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:FindPopulationSpecificHaplotypes |

 
Retrieve count or list of patients having specified genotypes/haplotypes. 

### Description

Retrieve count or list of patients having specified genotypes/haplotypes.

Population queries are designed to return a **count** of patients that match each item sought, with or without a **list** of patients matching the item(s) sought.

As described in [general guidance](operations.md#and-or-logic-in-queries), FHIR Genomics Operations do not support 'AND' logic unless stated otherwise. This particular operation supports a logical 'AND' of the 'haplotypes' parameter, specified by repeating the parameter. 'AND' logic is useful when searching for other subjects sharing a specific constellation of haplotypes, as in the following example that seeks patients having haplotype 'a' or 'b' or 'c', and haplotype 'd' or 'e' or 'f', and haplotype 'i' or 'j' or 'k':

```
...&haplotypes=a,b,c&haplotypes=d,e,f&haplotypes=i,j,k

```

### Parameters

* **Use**: IN
  * **Name**: haplotypes
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: List of haplotypes and/or genotypes being sought. Must be in token or codesystem|code format.
* **Use**: IN
  * **Name**: genomicSourceClass
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.
* **Use**: IN
  * **Name**: includePatientList
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [boolean](http://hl7.org/fhir/R5/datatypes.html#boolean)
  * **Binding**: 
  * **Documentation**: Include list of matching patients if set to true. Default=false.
* **Use**: OUT
  * **Name**: haplotypes
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: 
  * **Binding**: 
  * **Documentation**: (one for each haplotype in haplotypeList)
* **Use**: OUT
  * **Name**: haplotypes.haplotypeItem
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: haplotype/genotype from haplotypeList
* **Use**: OUT
  * **Name**: haplotypes.numerator
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [Quantity](http://hl7.org/fhir/R5/datatypes.html#Quantity)
  * **Binding**: 
  * **Documentation**: Count of patients having this variant
* **Use**: OUT
  * **Name**: haplotypes.denominator
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Quantity](http://hl7.org/fhir/R5/datatypes.html#Quantity)
  * **Binding**: 
  * **Documentation**: Count of patients in the cohort searched
* **Use**: OUT
  * **Name**: haplotypes.subject
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: Patient ID. Include if includePatientList=true

### Notes:

#### Error Codes

Valid response codes are shown in the following table. Additional response codes (e.g. 5xx server error) may also be encountered.

| | |
| :--- | :--- |
| 200 | Successfully executed request |
| 400 | ERROR: Invalid query parameters |
| 404 | ERROR: Patient not found |
| 422 | ERROR: Failed[LiftOver](operations.md#liftover) |

#### Examples

A transplant specialist is looking for potential unrelated donors in the donor registry that are a perfect HLA match for their patient.

```

GET .../$find-population-specific-haplotypes?haplotypes=A*1&haplotypes=B*8&haplotypes=DRB1*03&haplotypes=DRB3*01&haplotypes=A*31&haplotypes=B*35&haplotypes=DRB1*04&haplotypes=DRB4*01:02&includePatientList=true

```

See [example output](Parameters-FindPopulationSpecificHaplotypesOutput.md).



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "find-population-specific-haplotypes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-population-specific-haplotypes",
  "version" : "4.0.0-ballot",
  "name" : "FindPopulationSpecificHaplotypes",
  "title" : "Find Population Specific Haplotypes",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Retrieve count or list of patients having specified genotypes/haplotypes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "code" : "match",
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "haplotypes",
      "use" : "in",
      "min" : 1,
      "max" : "*",
      "documentation" : "List of haplotypes and/or genotypes being sought. Must be in token or codesystem|code format.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "genomicSourceClass",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "includePatientList",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Include list of matching patients if set to true. Default=false.",
      "type" : "boolean"
    },
    {
      "name" : "haplotypes",
      "use" : "out",
      "min" : 1,
      "max" : "*",
      "documentation" : "(one for each haplotype in haplotypeList)",
      "part" : [
        {
          "name" : "haplotypeItem",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "haplotype/genotype from haplotypeList",
          "type" : "string"
        },
        {
          "name" : "numerator",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "Count of patients having this variant",
          "type" : "Quantity"
        },
        {
          "name" : "denominator",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "documentation" : "Count of patients in the cohort searched",
          "type" : "Quantity"
        },
        {
          "name" : "subject",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "documentation" : "Patient ID. Include if includePatientList=true",
          "type" : "string"
        }
      ]
    }
  ]
}

```
