# variant-with-molec-consequences - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **variant-with-molec-consequences**

## Example Observation: variant-with-molec-consequences

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genetic variant assessment

**subject**: [Alanine B. Everyone Unknown, DoB: 1951-01-20 ( Medical Record Number: m234 (use: usual, ))](Patient-HG00403.md)

**effective**: 2023-06-01

**performer**: [Organization Some lab](Organization-ExampleLab.md)

**value**: Present

> **component****code**:Genomic source class**value**:Germline

> **component****code**:Genomic reference sequence ID**value**:NC_000001.10

> **component****code**:Allelic state**value**:Heterozygous

> **component****code**:Discrete genetic variant**value**:NC_000001.10:g.86852621A>G

> **component****code**:Sample VAF**value**: 0.6 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Genomic Ref allele [ID]**value**: A

> **component****code**:Genomic Alt allele [ID]**value**: G

> **component****code**:Genomic coord system**value**:0-based interval counting

> **component****code**:Variant exact start-end**value**: 86852620-?

> **component****code**:Population allele frequency**value**: 0.327084 1(Details: UCUM code1 = '1')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "variant-with-molec-consequences",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "69548-6",
        "display" : "Genetic variant assessment"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/HG00403"
  },
  "effectiveDateTime" : "2023-06-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleLab"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA9633-4",
        "display" : "Present"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48002-0",
            "display" : "Genomic source class"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6683-2",
            "display" : "Germline"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48013-7",
            "display" : "Genomic reference sequence ID"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ncbi.nlm.nih.gov/refseq",
            "code" : "NC_000001.10"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "53034-5",
            "display" : "Allelic state"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6706-1",
            "display" : "Heterozygous"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81252-9",
            "display" : "Discrete genetic variant"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NC_000001.10:g.86852621A>G",
            "display" : "NC_000001.10:g.86852621A>G"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81258-6",
            "display" : "Sample VAF"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 0.6,
        "unit" : "relative frequency of a particular allele in the specimen",
        "system" : "http://unitsofmeasure.org",
        "code" : "1"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "69547-8",
            "display" : "Genomic Ref allele [ID]"
          }
        ]
      },
      "valueString" : "A"
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "69551-0",
            "display" : "Genomic Alt allele [ID]"
          }
        ]
      },
      "valueString" : "G"
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "92822-6",
            "display" : "Genomic coord system"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA30100-4",
            "display" : "0-based interval counting"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81254-5"
          }
        ],
        "text" : "Variant exact start-end"
      },
      "valueRange" : {
        "low" : {
          "value" : 86852620
        }
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "92821-8"
          }
        ],
        "text" : "Population allele frequency"
      },
      "valueQuantity" : {
        "value" : 0.327084,
        "system" : "http://unitsofmeasure.org",
        "code" : "1"
      }
    }
  ]
}

```
