# therapuDrug1-interact-smn1-smn2 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **therapuDrug1-interact-smn1-smn2**

## Example Observation: therapuDrug1-interact-smn1-smn2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Therapeutic Implication

**subject**: A Newborn

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**derivedFrom**: 

* [Observation Genetic variant assessment](Observation-obs1-interact-smn1-smn2.md)
* [Observation Genetic variant assessment](Observation-obs2-interact-smn1-smn2.md)

> **component****code**:Associated phenotype**value**:Spinal muscular atrophy (SMA)

> **component****code**:Medication assessed**value**:nusinersen (antisense oligonucleotide)

> **component****Related artifact**: No display for RelatedArtifact (type: citation; document: )**code**:Conclusion Text**value**: Spinal muscular atrophy (SMA) is an autosomal recessive disease characterized by the degeneration of alpha motor neurons in the spinal cord, leading to muscular atrophy. SMA is caused by deletions or mutations in the survival motor neuron 1 gene (SMN1). In humans, a nearly identical copy gene, SMN2, is present. Because SMN2 has been shown to decrease disease severity in a dose-dependent manner, SMN2 copy number is predictive of disease severity...The overarching recommendation is that all infants with two or three copies of SMN2 should receive immediate treatment



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "therapuDrug1-interact-smn1-smn2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "therapeutic-implication"
      }
    ]
  },
  "subject" : {
    "display" : "A Newborn"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "Observation/obs1-interact-smn1-smn2"
    },
    {
      "reference" : "Observation/obs2-interact-smn1-smn2"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81259-4"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "5262007",
            "display" : "Spinal muscular atrophy (disorder)"
          }
        ],
        "text" : "Spinal muscular atrophy (SMA)"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "51963-7",
            "display" : "Medication assessed"
          }
        ]
      },
      "valueCodeableConcept" : {
        "text" : "nusinersen (antisense oligonucleotide)"
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact",
          "valueRelatedArtifact" : {
            "type" : "citation",
            "document" : {
              "url" : "https://pubmed.ncbi.nlm.nih.gov/29614695/"
            }
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "conclusion-string"
          }
        ]
      },
      "valueString" : "Spinal muscular atrophy (SMA) is an autosomal recessive disease characterized by the degeneration of alpha motor neurons in the spinal cord, leading to muscular atrophy. SMA is caused by deletions or mutations in the survival motor neuron 1 gene (SMN1). In humans, a nearly identical copy gene, SMN2, is present. Because SMN2 has been shown to decrease disease severity in a dose-dependent manner, SMN2 copy number is predictive of disease severity...The overarching recommendation is that all infants with two or three copies of SMN2 should receive immediate treatment"
    }
  ]
}

```
