# pop-allele-freq - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **pop-allele-freq**

## Example Observation: pop-allele-freq

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Annotation](StructureDefinition-genomic-annotation.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genomic Annotation

**subject**: [Alanine B. Everyone Unknown, DoB: 1951-01-20 ( Medical Record Number: m234 (use: usual, ))](Patient-HG00403.md)

**effective**: 2023-06-01

**performer**: [Organization Some lab](Organization-ExampleLab.md)

**derivedFrom**: [Observation Genetic variant assessment](Observation-variant-with-molec-consequences.md)

> **component****KnowledgebaseAncestryGroup**:south asian**code**:Allelic frequency in Population**value**: 0.01

> **component****code**:Knowledge Base**value**:gnomAD v3.1.2 Exomes

> **component****code**:Annotation Pipeline**value**:Oakvar v2.34



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "pop-allele-freq",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-annotation"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "genomic-annotation"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/HG00403"
  },
  "effectiveDateTime" : "2023-06-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleLab"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "Observation/variant-with-molec-consequences"
    }
  ],
  "component" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/knowledgebase-ancestry-group",
          "valueCodeableConcept" : {
            "text" : "south asian"
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "92821-8",
            "display" : "Allelic frequency in Population"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 0.01
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "knowledge-base"
          }
        ]
      },
      "valueCodeableConcept" : {
        "text" : "gnomAD v3.1.2 Exomes"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "annotation-pipeline"
          }
        ]
      },
      "valueCodeableConcept" : {
        "text" : "Oakvar v2.34"
      }
    }
  ]
}

```
