# obs1-interact-smn1-smn2 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **obs1-interact-smn1-smn2**

## Example Observation: obs1-interact-smn1-smn2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genetic variant assessment

**subject**: A Newborn

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**value**: Present

**method**: PCR

> **component****code**:Gene studied [ID]**value**:SMN1

> **component****code**:DNA change type**value**:copy_number_variation

> **component****code**:Genomic source class [Type]**value**:Germline

> **component****code**:Genomic structural variant copy number**value**: 0 1(Details: UCUM code1 = '1')

> **component****code**:Genomic reference sequence [ID]**value**:NC_000005.10

> **component****code**:Structural variant inner start and end**value**: 70924941-70966375



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs1-interact-smn1-smn2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "69548-6"
      }
    ]
  },
  "subject" : {
    "display" : "A Newborn"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA9633-4",
        "display" : "Present"
      }
    ]
  },
  "method" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA26418-6",
        "display" : "PCR"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:11117",
            "display" : "SMN1"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48019-4"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.sequenceontology.org",
            "code" : "SO:0001019",
            "display" : "copy_number_variation"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48002-0"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6683-2",
            "display" : "Germline"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "82155-3"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 0,
        "system" : "http://unitsofmeasure.org",
        "code" : "1"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48013-7"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ncbi.nlm.nih.gov/refseq",
            "code" : "NC_000005.10"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81302-2"
          }
        ]
      },
      "valueRange" : {
        "low" : {
          "value" : 70924941
        },
        "high" : {
          "value" : 70966375
        }
      }
    }
  ]
}

```
