# molec-conseq1 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **molec-conseq1**

## Example Observation: molec-conseq1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Molecular Consequence](StructureDefinition-molecular-consequence.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Molecular Consequence

**subject**: [Alanine B. Everyone Unknown, DoB: 1951-01-20 ( Medical Record Number: m234 (use: usual, ))](Patient-HG00403.md)

**effective**: 2023-06-01

**performer**: [Organization Some lab](Organization-ExampleLab.md)

**interpretation**: High

**derivedFrom**: [Observation Genetic variant assessment](Observation-variant-with-molec-consequences.md)

> **component****code**:Transcript reference sequence [ID]**value**:NM_001395525.1

> **component****code**:Feature Consequence**value**:splice_donor_variant

> **component****code**:Functional Effect**value**:loss_of_function_variant



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "molec-conseq1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "molecular-consequence"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/HG00403"
  },
  "effectiveDateTime" : "2023-06-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleLab"
    }
  ],
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://example.org/pcingola.github.io/SnpEff/se_inputoutput/#impact-prediction",
          "code" : "HIGH",
          "display" : "High"
        }
      ]
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "Observation/variant-with-molec-consequences"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "51958-7",
            "display" : "Transcript reference sequence [ID]"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ncbi.nlm.nih.gov/refseq",
            "code" : "NM_001395525.1",
            "display" : "NM_001395525.1"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "feature-consequence"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.sequenceontology.org",
            "code" : "SO:0001575",
            "display" : "splice_donor_variant"
          },
          {
            "system" : "http://www.sequenceontology.org",
            "code" : "SO:0001627",
            "display" : "intron_variant"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "functional-effect"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.sequenceontology.org",
            "code" : "SO_0002054",
            "display" : "loss_of_function_variant"
          }
        ]
      }
    }
  ]
}

```
