# haplotype-hla-a-1-r4 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **haplotype-hla-a-1-r4**

## Example Observation: haplotype-hla-a-1-r4

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Haplotype name

**subject**: [Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

**effective**: 2018-07-26

**performer**: aTypingLab, Inc

**value**: HLA-A*03:01:01:01

**specimen**: [Specimen: identifier = http://example.org#001^123456789; type = Buccal smear sample; receivedTime = 2018-05-01](Specimen-specimen-hla-r4.md)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-A |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "haplotype-hla-a-1-r4",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "84414-2",
        "display" : "Haplotype name"
      },
      {
        "system" : "http://loinc.org",
        "code" : "57290-9",
        "display" : "HLA-A [Type] by High resolution"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExamplePatient"
  },
  "effectiveDateTime" : "2018-07-26",
  "performer" : [
    {
      "type" : "Organization",
      "display" : "aTypingLab, Inc"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.ebi.ac.uk/ipd/imgt/hla",
        "version" : "3.31.0",
        "code" : "HLA-A*03:01:01:01"
      }
    ]
  },
  "specimen" : {
    "reference" : "Specimen/specimen-hla-r4"
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6",
            "display" : "Gene studied [ID]"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:4931",
            "display" : "HLA-A"
          }
        ],
        "text" : "HLA-A"
      }
    }
  ]
}

```
