# VariantExample - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **VariantExample**

## Example Observation: VariantExample

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genetic variant assessment

**subject**: [Alanine B. Everyone Unknown, DoB: 1951-01-20 ( Medical Record Number: m234 (use: usual, ))](Patient-HG00403.md)

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**value**: Present

> **component****code**:Genomic reference sequence [ID]**value**:NC_000017.11

> **component****code**:Ref nucleotide**value**: ATTGAGGGAAAACACAT

> **component****code**:Alt allele**value**: T

> **component****code**:Genomic allele start-end**value**: 39723965-?

> **component****code**:Genomic coord system**value**:0-based interval counting



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "VariantExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "69548-6"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/HG00403"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA9633-4",
        "display" : "Present"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48013-7",
            "display" : "Genomic reference sequence [ID]"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ncbi.nlm.nih.gov/refseq",
            "code" : "NC_000017.11"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "69547-8",
            "display" : "Ref nucleotide"
          }
        ]
      },
      "valueString" : "ATTGAGGGAAAACACAT"
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "69551-0",
            "display" : "Alt allele"
          }
        ]
      },
      "valueString" : "T"
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81254-5",
            "display" : "Genomic allele start-end"
          }
        ]
      },
      "valueRange" : {
        "low" : {
          "value" : 39723965
        }
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "92822-6",
            "display" : "Genomic coord system"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA30100-4"
          }
        ]
      }
    }
  ]
}

```
