# Therapeutic-Implication-Clinical-Trial-2 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Therapeutic-Implication-Clinical-Trial-2**

## Example Observation: Therapeutic-Implication-Clinical-Trial-2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Therapeutic Implication

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**specimen**: [Specimen: identifier = http://example.org#123; accessionIdentifier = http://example.org#456; status = available; type = Buccal smear sample](Specimen-GenomicSpecimenExample02.md)

**derivedFrom**: [Observation Genotype display name](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md)

> **component****code**:Therapeutic Implication**value**:Does not meet eligibility criteria for clinical trial

> **component****code**:Associated Therapy**value**:NCT03131453



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "Therapeutic-Implication-Clinical-Trial-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "therapeutic-implication"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "specimen" : {
    "reference" : "Specimen/GenomicSpecimenExample02"
  },
  "derivedFrom" : [
    {
      "reference" : "Observation/Genotype-Clinical-Trial-Example-using-haplotypes"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "therapeutic-implication",
            "display" : "Therapeutic Implication"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "444734003",
            "display" : "Does not meet eligibility criteria for clinical trial"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "associated-therapy",
            "display" : "Associated Therapy"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://clinicaltrials.gov",
            "code" : "NCT03131453",
            "display" : "NCT03131453"
          }
        ]
      }
    }
  ]
}

```
