# STAG2-insertion-significance - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **STAG2-insertion-significance**

## Example Observation: STAG2-insertion-significance

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Diagnostic Implication](StructureDefinition-diagnostic-implication.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Diagnostic Implication

**subject**: [Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-somaticPatient.md)

**effective**: 2023-02-01

**performer**: [Practitioner Test Dolin](Practitioner-pathologistPractitioner.md)

**derivedFrom**: [Observation Genetic variant assessment](Observation-STAG2-insertion-var.md)

### Components

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Extension** | **Code** | **Value[x]** |
| * |  | Genetic variation clinical significance [Imp] | Likely Pathogenic |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "STAG2-insertion-significance",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "diagnostic-implication",
        "display" : "Diagnostic Implication"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/somaticPatient"
  },
  "effectiveDateTime" : "2023-02-01",
  "performer" : [
    {
      "reference" : "Practitioner/pathologistPractitioner"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "Observation/STAG2-insertion-var"
    }
  ],
  "component" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact",
          "valueRelatedArtifact" : {
            "type" : "citation",
            "document" : {
              "url" : "https://www.ncbi.nlm.nih.gov/gene/545#:~:text=ATR%20may%20function%20as%20an,radiation%20when%20ATM%20is%20deficient"
            }
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "53037-8",
            "display" : "Genetic variation clinical significance [Imp]"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA26332-9",
            "display" : "Likely Pathogenic"
          }
        ]
      }
    }
  ]
}

```
