# MultipleRepeatExpansions - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **MultipleRepeatExpansions**

## Example Observation: MultipleRepeatExpansions

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genetic variant assessment

**subject**: [Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

**effective**: 2023-06-01

**performer**: [Organization Some lab](Organization-ExampleLab.md)

**value**: Present

> **component****code**:Gene studied ID**value**:FMR1

> **component****code**:Cytogenetic (chromosome) location**value**:chrx

> **component****code**:Transcript reference sequence [ID]**value**:NM_002024.5

> **component****code**:DNA change (c.HGVS)**value**:NM_002024.5:c.-128_-69GGC[10]GGA[1]GGC[9]GGA[1]GGC[10]

> **component****code**:Genomic allele start-end**value**: 3-?

> **component****Repeat Motif Order**: 1**code**:Repeat Expansion Motif**value**: GGC

> **component****Repeat Motif Order**: 1**code**:Number of Repeat Expansions**value**: 10

> **component****Repeat Motif Order**: 2**code**:Repeat Expansion Motif**value**: GGA

> **component****Repeat Motif Order**: 2**code**:Number of Repeat Expansions**value**: 1

> **component****Repeat Motif Order**: 3**code**:Repeat Expansion Motif**value**: GGC

> **component****Repeat Motif Order**: 3**code**:Number of Repeat Expansions**value**: 9

> **component****Repeat Motif Order**: 4**code**:Repeat Expansion Motif**value**: GGA

> **component****Repeat Motif Order**: 4**code**:Number of Repeat Expansions**value**: 1

> **component****Repeat Motif Order**: 5**code**:Repeat Expansion Motif**value**: GGC

> **component****Repeat Motif Order**: 5**code**:Number of Repeat Expansions**value**: 10



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "MultipleRepeatExpansions",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "69548-6",
        "display" : "Genetic variant assessment"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExamplePatient"
  },
  "effectiveDateTime" : "2023-06-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleLab"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA9633-4",
        "display" : "Present"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6",
            "display" : "Gene studied ID"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:3775",
            "display" : "FMR1"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48001-2",
            "display" : "Cytogenetic (chromosome) location"
          }
        ]
      },
      "valueCodeableConcept" : {
        "text" : "chrx"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "51958-7",
            "display" : "Transcript reference sequence [ID]"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ncbi.nlm.nih.gov/refseq",
            "code" : "NM_002024.5",
            "display" : "NM_002024.5"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48004-6",
            "display" : "DNA change (c.HGVS)"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NM_002024.5:c.-128_-69GGC[10]GGA[1]GGC[9]GGA[1]GGC[10]",
            "display" : "NM_002024.5:c.-128_-69GGC[10]GGA[1]GGC[9]GGA[1]GGC[10]"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81254-5",
            "display" : "Genomic allele start-end"
          }
        ]
      },
      "valueRange" : {
        "low" : {
          "value" : 3
        }
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 1
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-motif",
            "display" : "Repeat Expansion Motif"
          }
        ]
      },
      "valueString" : "GGC"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 1
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-number",
            "display" : "Number of Repeat Expansions"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 10
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 2
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-motif",
            "display" : "Repeat Expansion Motif"
          }
        ]
      },
      "valueString" : "GGA"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 2
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-number",
            "display" : "Number of Repeat Expansions"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 1
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 3
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-motif",
            "display" : "Repeat Expansion Motif"
          }
        ]
      },
      "valueString" : "GGC"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 3
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-number",
            "display" : "Number of Repeat Expansions"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 9
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 4
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-motif",
            "display" : "Repeat Expansion Motif"
          }
        ]
      },
      "valueString" : "GGA"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 4
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-number",
            "display" : "Number of Repeat Expansions"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 1
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 5
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-motif",
            "display" : "Repeat Expansion Motif"
          }
        ]
      },
      "valueString" : "GGC"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 5
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-number",
            "display" : "Number of Repeat Expansions"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 10
      }
    }
  ]
}

```
