# GrouperEx01 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **GrouperEx01**

## Example Observation: GrouperEx01

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**status**: Final

**category**: Laboratory, Genetics

**code**: Group

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**hasMember**: 

* [clopidogrel, poor metabolizer](Observation-TxImp01.md)
* [voriconazole, poor metabolizer](Observation-TxImp02.md)
* [citalopram, poor metabolizer](Observation-TxImp03.md)
* [escitalopram, poor metabolizer](Observation-TxImp04.md)
* [amitriptyline, poor metabolizer](Observation-TxImp05.md)
* [medium sensitivity to warfarin](Observation-TxImp06.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "GrouperEx01",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl",
        "code" : "C43359",
        "display" : "Group"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/TxImp01",
      "display" : "clopidogrel, poor metabolizer"
    },
    {
      "reference" : "Observation/TxImp02",
      "display" : "voriconazole, poor metabolizer"
    },
    {
      "reference" : "Observation/TxImp03",
      "display" : "citalopram, poor metabolizer"
    },
    {
      "reference" : "Observation/TxImp04",
      "display" : "escitalopram, poor metabolizer"
    },
    {
      "reference" : "Observation/TxImp05",
      "display" : "amitriptyline, poor metabolizer"
    },
    {
      "reference" : "Observation/TxImp06",
      "display" : "medium sensitivity to warfarin"
    }
  ]
}

```
