# EGFR-L858R-var - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **EGFR-L858R-var**

## Example Observation: EGFR-L858R-var

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genetic variant assessment

**subject**: [Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-somaticPatient.md)

**effective**: 2023-02-01

**performer**: [Practitioner Test Dolin](Practitioner-pathologistPractitioner.md)

**value**: Present

**method**: Sequencing

> **component****code**:Discrete genetic variant**value**:EGFR L858R

> **component****code**:Amino acid change (pHGVS)**value**:NP_005219.2:p.Leu858Arg

> **component****code**:DNA change type**value**:SNV

> **component****code**:DNA change (c.HGVS)**value**:NM_005228.4:c.2573T>G

> **component****code**:Gene studied [ID]**value**:EGFR

> **component****code**:Genomic DNA change (gHGVS)**value**:NC_000007.13:g.55259515T>G

> **component****code**:Genomic source class [Type]**value**:Somatic

> **component****code**:Sample variant allelic frequency [NFr]**value**: 0.066 decimal



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "EGFR-L858R-var",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "69548-6"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/somaticPatient"
  },
  "effectiveDateTime" : "2023-02-01",
  "performer" : [
    {
      "reference" : "Practitioner/pathologistPractitioner"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA9633-4",
        "display" : "Present"
      }
    ]
  },
  "method" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA26398-0",
        "display" : "Sequencing"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81252-9"
          }
        ]
      },
      "valueCodeableConcept" : {
        "text" : "EGFR L858R"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48005-3"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NP_005219.2:p.Leu858Arg"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48019-4"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.sequenceontology.org",
            "code" : "SO:0001483",
            "display" : "SNV"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48004-6"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NM_005228.4:c.2573T>G"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:3236",
            "display" : "EGFR"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81290-9"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NC_000007.13:g.55259515T>G"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48002-0"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6684-0",
            "display" : "Somatic"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81258-6"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 0.066,
        "unit" : "decimal",
        "system" : "http://unitsofmeasure.org"
      }
    }
  ]
}

```
