# somaticStudy - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **somaticStudy**

## Example GenomicStudy: somaticStudy

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**status**: Available

**type**: My Test Cancer 700 Gene Panel

**subject**: [Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-somaticPatient.md)

**startDate**: 2023-02-02

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Adenocarcinoma of lung, stage IV (disorder) |

**note**: 

> 

I. Assay Overview: The Genomic Cancer Testing Assay is a comprehensive molecular examination designed to detect and quantify specific DNA and RNA alterations associated with malignancies. The test incorporates Next Generation Sequencing (NGS) technology to profile tumor samples, providing insights into the genomic alterations that drive tumor behavior and prognosis. II. Target Genes and Biomarkers: This assay evaluates an extensive panel of cancer-related genes, focusing on mutations, copy number variations, fusions, and select RNA expression levels known to be relevant in the oncology field. The analyzed genes are implicated in various cancer types and have established therapeutic, diagnostic, prognostic, or predictive relevance. Genes tested: ABL1, ATK1, ALK, APC, etc. III. Methodology: Sample Type: Formalin-fixed, paraffin-embedded (FFPE) tumor tissue. Sequencing Platform: Illumina-based NGS technology. Library Preparation: Amplification of specific target regions within the genes of interest. Bioinformatics Analysis: Employing advanced algorithms and databases to annotate and interpret the detected variants' clinical significance. IV. Assay Performance: Sensitivity: Detects variants with a mutant allele frequency (MAF) as low as 5%. Specificity: >99% for single nucleotide variants (SNVs) and indels. Reportable Range: Identification and quantification of SNVs, indels, fusions, amplifications, and RNA expression levels of specific genes. V. Clinical Interpretation: The report offers a concise clinical interpretation of identified genomic alterations, linking the detected variants to FDA-approved therapies, clinical trials, or the patient's potential response to specific treatments. VI. Limitations: The assay might not detect alterations present at low levels or in regions not covered by the test. Variants may be present in genes not included in the panel. The test does not assess epigenetic changes, like methylation status. False negatives and false positives, although rare, may occur due to the technical limitations of the methodology employed. VII. Quality Assurance: The laboratory follows CAP/CLIA guidelines, ensuring stringent quality control and assurance practices at each step, from sample reception to result reporting. VIII. Result Delivery: Results are delivered within 10-14 working days from the sample receipt. The report outlines detected genomic alterations, their clinical implications, and potential therapeutic options. IX. Contact: For further clarification or questions regarding the results, healthcare providers are encouraged to contact our molecular pathology board-certified experts.


> **analysis****methodType**:Sequence analysis of the entire coding region,Deletion/duplication analysis**changeType**:SNV,MNV,delins,CNV**genomeBuild**:GRCh38**focus**:[Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-somaticPatient.md)**specimen**:
* [Specimen: identifier = http://example.org/identifiers/specimens#222333; status = available; type = Specimen from lung obtained by biopsy (specimen); receivedTime = 2023-01-23 01:01:01+0000; note = Tumor: 20%](Specimen-tumorSpecimen.md)
* [Specimen: identifier = http://example.org/identifiers/specimens#444555; status = available; type = Blood specimen (specimen); receivedTime = 2023-01-23 01:01:01+0000](Specimen-normalSpecimen.md)
**date**: 2023-02-02 01:01:10-0600**note**:
> 

For technical reasons, BCR gene was deemed uncallable.


**regionsStudied**:[DocumentReference: identifier = http://example.org/identifiers/files#11117; status = current; docStatus = preliminary; description = WES_FullSequencedRegion_GRCh38: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline.; securityLabel = Restricted](DocumentReference-WES-FullSequencedRegion-GRCh38.md)

### Outputs

| | | |
| :--- | :--- | :--- |
| - | **File** | **Type** |
| * | [DocumentReference: identifier = http://example.org/identifiers/files#1134121; status = current; docStatus = preliminary; description = VCF file containing identified variants; securityLabel = Restricted](DocumentReference-somaticVCFfile.md) | VCF |


> **analysis****methodType**:RNA analysis**changeType**:gene_fusion,transcript_variant**focus**:[Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-somaticPatient.md)**specimen**:[Specimen: identifier = http://example.org/identifiers/specimens#222333; status = available; type = Specimen from lung obtained by biopsy (specimen); receivedTime = 2023-01-23 01:01:01+0000; note = Tumor: 20%](Specimen-tumorSpecimen.md)**date**: 2023-02-02 01:01:10-0600**regionsStudied**:[DocumentReference: identifier = http://example.org/identifiers/files#1076146520; status = current; docStatus = preliminary; description = Studied region for RNA sequencing.; securityLabel = Restricted](DocumentReference-FullGenome-GRCh38.md)



## Resource Content

```json
{
  "resourceType" : "GenomicStudy",
  "id" : "somaticStudy",
  "status" : "available",
  "type" : [
    {
      "text" : "My Test Cancer 700 Gene Panel"
    }
  ],
  "subject" : {
    "reference" : "Patient/somaticPatient"
  },
  "startDate" : "2023-02-02",
  "reason" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "424993006",
            "display" : "Adenocarcinoma of lung, stage IV (disorder)"
          }
        ]
      }
    }
  ],
  "note" : [
    {
      "text" : "I. Assay Overview: The Genomic Cancer Testing Assay is a comprehensive molecular examination designed to detect and quantify specific DNA and RNA alterations associated with malignancies. The test incorporates Next Generation Sequencing (NGS) technology to profile tumor samples, providing insights into the genomic alterations that drive tumor behavior and prognosis. II. Target Genes and Biomarkers: This assay evaluates an extensive panel of cancer-related genes, focusing on mutations, copy number variations, fusions, and select RNA expression levels known to be relevant in the oncology field. The analyzed genes are implicated in various cancer types and have established therapeutic, diagnostic, prognostic, or predictive relevance. Genes tested: ABL1, ATK1, ALK, APC, etc. III. Methodology: Sample Type: Formalin-fixed, paraffin-embedded (FFPE) tumor tissue. Sequencing Platform: Illumina-based NGS technology. Library Preparation: Amplification of specific target regions within the genes of interest. Bioinformatics Analysis: Employing advanced algorithms and databases to annotate and interpret the detected variants' clinical significance. IV. Assay Performance: Sensitivity: Detects variants with a mutant allele frequency (MAF) as low as 5%. Specificity: >99% for single nucleotide variants (SNVs) and indels. Reportable Range: Identification and quantification of SNVs, indels, fusions, amplifications, and RNA expression levels of specific genes. V. Clinical Interpretation: The report offers a concise clinical interpretation of identified genomic alterations, linking the detected variants to FDA-approved therapies, clinical trials, or the patient's potential response to specific treatments. VI. Limitations: The assay might not detect alterations present at low levels or in regions not covered by the test. Variants may be present in genes not included in the panel. The test does not assess epigenetic changes, like methylation status. False negatives and false positives, although rare, may occur due to the technical limitations of the methodology employed. VII. Quality Assurance: The laboratory follows CAP/CLIA guidelines, ensuring stringent quality control and assurance practices at each step, from sample reception to result reporting. VIII. Result Delivery: Results are delivered within 10-14 working days from the sample receipt. The report outlines detected genomic alterations, their clinical implications, and potential therapeutic options. IX. Contact: For further clarification or questions regarding the results, healthcare providers are encouraged to contact our molecular pathology board-certified experts."
    }
  ],
  "analysis" : [
    {
      "methodType" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/genomicstudy-methodtype",
              "code" : "sequence-analysis-of-the-entire-coding-region",
              "display" : "Sequence analysis of the entire coding region"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/genomicstudy-methodtype",
              "code" : "deletion-duplication-analysis",
              "display" : "Deletion/duplication analysis"
            }
          ]
        }
      ],
      "changeType" : [
        {
          "coding" : [
            {
              "system" : "http://www.sequenceontology.org",
              "code" : "SO:0001483",
              "display" : "SNV"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://www.sequenceontology.org",
              "code" : "SO:0002007",
              "display" : "MNV"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://www.sequenceontology.org",
              "code" : "SO:1000032",
              "display" : "delins"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://www.sequenceontology.org",
              "code" : "SO:0001019",
              "display" : "CNV"
            }
          ]
        }
      ],
      "genomeBuild" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA26806-2",
            "display" : "GRCh38"
          }
        ]
      },
      "focus" : [
        {
          "reference" : "Patient/somaticPatient"
        }
      ],
      "specimen" : [
        {
          "reference" : "Specimen/tumorSpecimen"
        },
        {
          "reference" : "Specimen/normalSpecimen"
        }
      ],
      "date" : "2023-02-02T01:01:10-06:00",
      "note" : [
        {
          "text" : "For technical reasons, BCR gene was deemed uncallable."
        }
      ],
      "regionsStudied" : [
        {
          "reference" : "DocumentReference/WES-FullSequencedRegion-GRCh38"
        }
      ],
      "output" : [
        {
          "file" : {
            "reference" : "DocumentReference/somaticVCFfile"
          },
          "type" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/genomicstudy-dataformat",
                "code" : "vcf",
                "display" : "VCF"
              }
            ]
          }
        }
      ]
    },
    {
      "methodType" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/genomicstudy-methodtype",
              "code" : "rna-analysis",
              "display" : "RNA analysis"
            }
          ]
        }
      ],
      "changeType" : [
        {
          "coding" : [
            {
              "system" : "http://www.sequenceontology.org",
              "code" : "SO:0001565",
              "display" : "gene_fusion"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://www.sequenceontology.org",
              "code" : "SO:0001576",
              "display" : "transcript_variant"
            }
          ]
        }
      ],
      "focus" : [
        {
          "reference" : "Patient/somaticPatient"
        }
      ],
      "specimen" : [
        {
          "reference" : "Specimen/tumorSpecimen"
        }
      ],
      "date" : "2023-02-02T01:01:10-06:00",
      "regionsStudied" : [
        {
          "reference" : "DocumentReference/FullGenome-GRCh38"
        }
      ]
    }
  ]
}

```
