# lungMass - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **lungMass**

## Example GenomicStudy: lungMass

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**status**: Available

**type**: Solid tumor whole exome sequencing panel

**subject**: [John Junior Doe (official) Unknown, DoB: 2001-01-01 ( Medical record number: 11117 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-genomicPatient.md)

**startDate**: 2019-03-01

**basedOn**: [ServiceRequest Molecular genetic test (procedure)](ServiceRequest-genomicServiceRequest.md)

**interpreter**: [Practitioner Jane Doel](Practitioner-practitioner02.md)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Lung mass (finding) |

**note**: 

> 

For technical reasons, PIK3CB was deemed uncallable.


> **analysis****methodType**:Sequence analysis of the entire coding region**changeType**:SNV,MNV,delins**genomeBuild**:GRCh38**instantiatesUri**:[https://pubmed.ncbi.nlm.nih.gov/33927380/](https://pubmed.ncbi.nlm.nih.gov/33927380/)**focus**:[John Junior Doe (official) Unknown, DoB: 2001-01-01 ( Medical record number: 11117 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-genomicPatient.md)**specimen**:[Specimen: identifier = http://example.org/identifiers/specimens#4; status = available; type = Specimen from lung obtained by biopsy (specimen); receivedTime = 2019-03-01 01:01:01+0000](Specimen-genomicSpecimen.md)**date**: 2019-03-01 01:01:10-0600**note**:
> 

For technical reasons, PIK3CB was deemed uncallable using this method.


**regionsStudied**:[DocumentReference: identifier = http://example.org/identifiers/files#11117; status = current; docStatus = preliminary; description = WES_FullSequencedRegion_GRCh38: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline.; securityLabel = Restricted](DocumentReference-WES-FullSequencedRegion-GRCh38.md)**regionsCalled**:[DocumentReference: identifier = http://example.org/identifiers/files#11118; status = current; docStatus = preliminary; description = SimpleVariantAnalysis_called: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline.; securityLabel = Restricted](DocumentReference-SimpleVariantAnalysis-called.md)

### Outputs

| | | |
| :--- | :--- | :--- |
| - | **File** | **Type** |
| * | [DocumentReference: identifier = http://example.org/identifiers/files#11119; status = current; docStatus = preliminary; description = genomicVCFfile_simple: A sample Document Reference instance representing a VCF file that may be used as input or output of a genomic analysis pipeline.; securityLabel = Restricted](DocumentReference-genomicVCFfile-simple.md) | VCF |

### Performers

| | | |
| :--- | :--- | :--- |
| - | **Actor** | **Role** |
| * | [Practitioner Jane Doel](Practitioner-practitioner02.md) | Performer |

### Devices

| | |
| :--- | :--- |
| - | **Device** |
| * | [Device: identifier = http://example.org/identifiers/devices#11112; status = active; manufacturer = Vanderbilt Genetics Institute; type = Software (physical object)](Device-triodenovo-software.md) |


> **analysis****methodType**:Deletion/duplication analysis**changeType**:CNV**genomeBuild**:GRCh38**instantiatesUri**:[https://pubmed.ncbi.nlm.nih.gov/33927380/](https://pubmed.ncbi.nlm.nih.gov/33927380/)**focus**:[John Junior Doe (official) Unknown, DoB: 2001-01-01 ( Medical record number: 11117 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-genomicPatient.md)**specimen**:[Specimen: identifier = http://example.org/identifiers/specimens#4; status = available; type = Specimen from lung obtained by biopsy (specimen); receivedTime = 2019-03-01 01:01:01+0000](Specimen-genomicSpecimen.md)**date**: 2019-03-01 01:01:10-0600**note**:
> 

For technical reasons, PIK3CB was deemed uncallable using this method.


**regionsStudied**:[DocumentReference: identifier = http://example.org/identifiers/files#11117; status = current; docStatus = preliminary; description = WES_FullSequencedRegion_GRCh38: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline.; securityLabel = Restricted](DocumentReference-WES-FullSequencedRegion-GRCh38.md)**regionsCalled**:[DocumentReference: identifier = http://example.org/identifiers/files#11120; status = current; docStatus = preliminary; description = CNVAnalysis_called: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline.; securityLabel = Restricted](DocumentReference-CNVAnalysis-called.md)

### Outputs

| | | |
| :--- | :--- | :--- |
| - | **File** | **Type** |
| * | [DocumentReference: identifier = http://example.org/identifiers/files#11121; status = current; docStatus = preliminary; description = genomicVCFfile_cnv: A sample Document Reference instance representing a VCF file that may be used as input or output of a genomic analysis pipeline.; securityLabel = Restricted](DocumentReference-genomicVCFfile-cnv.md) | VCF |

### Performers

| | | |
| :--- | :--- | :--- |
| - | **Actor** | **Role** |
| * | [Practitioner Jane Doel](Practitioner-practitioner02.md) | Performer |




## Resource Content

```json
{
  "resourceType" : "GenomicStudy",
  "id" : "lungMass",
  "status" : "available",
  "type" : [
    {
      "text" : "Solid tumor whole exome sequencing panel"
    }
  ],
  "subject" : {
    "reference" : "Patient/genomicPatient"
  },
  "startDate" : "2019-03-01",
  "basedOn" : [
    {
      "reference" : "ServiceRequest/genomicServiceRequest"
    }
  ],
  "interpreter" : [
    {
      "reference" : "Practitioner/practitioner02"
    }
  ],
  "reason" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "309529002",
            "display" : "Lung mass (finding)"
          }
        ]
      }
    }
  ],
  "note" : [
    {
      "text" : "For technical reasons, PIK3CB was deemed uncallable."
    }
  ],
  "analysis" : [
    {
      "methodType" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/genomicstudy-methodtype",
              "code" : "sequence-analysis-of-the-entire-coding-region",
              "display" : "Sequence analysis of the entire coding region"
            }
          ]
        }
      ],
      "changeType" : [
        {
          "coding" : [
            {
              "system" : "http://www.sequenceontology.org",
              "code" : "SO:0001483",
              "display" : "SNV"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://www.sequenceontology.org",
              "code" : "SO:0002007",
              "display" : "MNV"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://www.sequenceontology.org",
              "code" : "SO:1000032",
              "display" : "delins"
            }
          ]
        }
      ],
      "genomeBuild" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA26806-2",
            "display" : "GRCh38"
          }
        ]
      },
      "instantiatesUri" : "https://pubmed.ncbi.nlm.nih.gov/33927380/",
      "focus" : [
        {
          "reference" : "Patient/genomicPatient"
        }
      ],
      "specimen" : [
        {
          "reference" : "Specimen/genomicSpecimen"
        }
      ],
      "date" : "2019-03-01T01:01:10-06:00",
      "note" : [
        {
          "text" : "For technical reasons, PIK3CB was deemed uncallable using this method."
        }
      ],
      "regionsStudied" : [
        {
          "reference" : "DocumentReference/WES-FullSequencedRegion-GRCh38"
        }
      ],
      "regionsCalled" : [
        {
          "reference" : "DocumentReference/SimpleVariantAnalysis-called"
        }
      ],
      "output" : [
        {
          "file" : {
            "reference" : "DocumentReference/genomicVCFfile-simple"
          },
          "type" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/genomicstudy-dataformat",
                "code" : "vcf",
                "display" : "VCF"
              }
            ]
          }
        }
      ],
      "performer" : [
        {
          "actor" : {
            "reference" : "Practitioner/practitioner02"
          },
          "role" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                "code" : "PRF",
                "display" : "Performer"
              }
            ]
          }
        }
      ],
      "device" : [
        {
          "device" : {
            "reference" : "Device/triodenovo-software"
          }
        }
      ]
    },
    {
      "methodType" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/genomicstudy-methodtype",
              "code" : "deletion-duplication-analysis",
              "display" : "Deletion/duplication analysis"
            }
          ]
        }
      ],
      "changeType" : [
        {
          "coding" : [
            {
              "system" : "http://www.sequenceontology.org",
              "code" : "SO:0001019",
              "display" : "CNV"
            }
          ]
        }
      ],
      "genomeBuild" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA26806-2",
            "display" : "GRCh38"
          }
        ]
      },
      "instantiatesUri" : "https://pubmed.ncbi.nlm.nih.gov/33927380/",
      "focus" : [
        {
          "reference" : "Patient/genomicPatient"
        }
      ],
      "specimen" : [
        {
          "reference" : "Specimen/genomicSpecimen"
        }
      ],
      "date" : "2019-03-01T01:01:10-06:00",
      "note" : [
        {
          "text" : "For technical reasons, PIK3CB was deemed uncallable using this method."
        }
      ],
      "regionsStudied" : [
        {
          "reference" : "DocumentReference/WES-FullSequencedRegion-GRCh38"
        }
      ],
      "regionsCalled" : [
        {
          "reference" : "DocumentReference/CNVAnalysis-called"
        }
      ],
      "output" : [
        {
          "file" : {
            "reference" : "DocumentReference/genomicVCFfile-cnv"
          },
          "type" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/genomicstudy-dataformat",
                "code" : "vcf",
                "display" : "VCF"
              }
            ]
          }
        }
      ],
      "performer" : [
        {
          "actor" : {
            "reference" : "Practitioner/practitioner02"
          },
          "role" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                "code" : "PRF",
                "display" : "Performer"
              }
            ]
          }
        }
      ]
    }
  ]
}

```
