# PGXGenomicStudy - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **PGXGenomicStudy**

## Example GenomicStudy: PGXGenomicStudy

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**status**: Available

**type**: PGX sequencing panel

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**startDate**: 2021-01-01

**basedOn**: [ServiceRequest emerge-seq-ngs-pnl](ServiceRequest-eMERGEServiceRequest.md)

**note**: 

> 

For technical reasons, PIK3CB was deemed uncallable.


### Analyses

| | | | |
| :--- | :--- | :--- | :--- |
| - | **GenomeBuild** | **Date** | **Note** |
| * | GRCh38 | 2021-01-01 01:01:10-0600 | > protein-coding and exon-splicing regions |



## Resource Content

```json
{
  "resourceType" : "GenomicStudy",
  "id" : "PGXGenomicStudy",
  "status" : "available",
  "type" : [
    {
      "text" : "PGX sequencing panel"
    }
  ],
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "startDate" : "2021-01-01",
  "basedOn" : [
    {
      "reference" : "ServiceRequest/eMERGEServiceRequest"
    }
  ],
  "note" : [
    {
      "text" : "For technical reasons, PIK3CB was deemed uncallable."
    }
  ],
  "analysis" : [
    {
      "genomeBuild" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA26806-2",
            "display" : "GRCh38"
          }
        ]
      },
      "date" : "2021-01-01T01:01:10-06:00",
      "note" : [
        {
          "text" : "protein-coding and exon-splicing regions"
        }
      ]
    }
  ]
}

```
