# genomicVCFfile-cnv - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **genomicVCFfile-cnv**

## Example DocumentReference: genomicVCFfile-cnv

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Data File](StructureDefinition-genomic-data-file.md)

**identifier**: `http://example.org/identifiers/files`/11121

**status**: Current

**docStatus**: Preliminary

**description**: 

genomicVCFfile_cnv: A sample Document Reference instance representing a VCF file that may be used as input or output of a genomic analysis pipeline.

**securityLabel**: Restricted

> **content**

### Attachments

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Url** | **Title** | **Creation** |
| * | [https://chat.fhir.org/user_uploads/10155/dxn3s6R1Y-Cv0h-1bTCu-JvY/genomicVCFFile_cnv.vcf](https://chat.fhir.org/user_uploads/10155/dxn3s6R1Y-Cv0h-1bTCu-JvY/genomicVCFFile_cnv.vcf) | genomicVCFfile_cnv | 2019-03-01 01:02:01+0100 |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "genomicVCFfile-cnv",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/identifiers/files",
      "value" : "11121"
    }
  ],
  "status" : "current",
  "docStatus" : "preliminary",
  "description" : "genomicVCFfile_cnv: A sample Document Reference instance representing a VCF file that may be used as input or output of a genomic analysis pipeline.",
  "securityLabel" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
          "code" : "R",
          "display" : "Restricted"
        }
      ]
    }
  ],
  "content" : [
    {
      "attachment" : {
        "url" : "https://chat.fhir.org/user_uploads/10155/dxn3s6R1Y-Cv0h-1bTCu-JvY/genomicVCFFile_cnv.vcf",
        "title" : "genomicVCFfile_cnv",
        "creation" : "2019-03-01T01:02:01+01:00"
      }
    }
  ]
}

```
