# genomicFileProbandBAM - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **genomicFileProbandBAM**

## Example DocumentReference: genomicFileProbandBAM

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Data File](StructureDefinition-genomic-data-file.md)

**identifier**: `http://example.org/identifiers/files`/11118

**status**: Current

**docStatus**: Preliminary

**subject**: [Child Denovo (official) (no stated gender), DoB Unknown ( Medical record number: 1234-11111 (use: temp, ))](Patient-denovoChild.md)

**description**: 

A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline.

**securityLabel**: Restricted

> **content**

### Attachments

| | | |
| :--- | :--- | :--- |
| - | **Url** | **Title** |
| * | [http://example.org/identifiers/files/11111](http://example.org/identifiers/files/11111) | Probands BAM file |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "genomicFileProbandBAM",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/identifiers/files",
      "value" : "11118"
    }
  ],
  "status" : "current",
  "docStatus" : "preliminary",
  "subject" : {
    "reference" : "Patient/denovoChild"
  },
  "description" : "A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline.",
  "securityLabel" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
          "code" : "R",
          "display" : "Restricted"
        }
      ]
    }
  ],
  "content" : [
    {
      "attachment" : {
        "url" : "http://example.org/identifiers/files/11111",
        "title" : "Probands BAM file"
      }
    }
  ]
}

```
