# WES-UncallableRegions-GRCh38 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **WES-UncallableRegions-GRCh38**

## Example DocumentReference: WES-UncallableRegions-GRCh38

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Data File](StructureDefinition-genomic-data-file.md)

**identifier**: `http://example.org/identifiers/files`/11146520

**status**: Current

**docStatus**: Preliminary

**description**: 

Regions deemed uncallable (generally due to low coverage).

**securityLabel**: Restricted

> **content**

### Attachments

| | | |
| :--- | :--- | :--- |
| - | **Url** | **Title** |
| * | [https://chat.fhir.org/user_uploads/10155/WrHnNR_WvMcqM2aXQ3BRHxlA/WES-UncallableRegions-GRCh38.bed](https://chat.fhir.org/user_uploads/10155/WrHnNR_WvMcqM2aXQ3BRHxlA/WES-UncallableRegions-GRCh38.bed) | WES-UncallableRegions-GRCh38 |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "WES-UncallableRegions-GRCh38",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/identifiers/files",
      "value" : "11146520"
    }
  ],
  "status" : "current",
  "docStatus" : "preliminary",
  "description" : "Regions deemed uncallable (generally due to low coverage).",
  "securityLabel" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
          "code" : "R",
          "display" : "Restricted"
        }
      ]
    }
  ],
  "content" : [
    {
      "attachment" : {
        "url" : "https://chat.fhir.org/user_uploads/10155/WrHnNR_WvMcqM2aXQ3BRHxlA/WES-UncallableRegions-GRCh38.bed",
        "title" : "WES-UncallableRegions-GRCh38"
      }
    }
  ]
}

```
