# WES-FullSequencedRegion-GRCh38 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **WES-FullSequencedRegion-GRCh38**

## Example DocumentReference: WES-FullSequencedRegion-GRCh38

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Data File](StructureDefinition-genomic-data-file.md)

**identifier**: `http://example.org/identifiers/files`/11117

**status**: Current

**docStatus**: Preliminary

**description**: 

WES_FullSequencedRegion_GRCh38: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline.

**securityLabel**: Restricted

> **content**

### Attachments

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Url** | **Title** | **Creation** |
| * | [https://chat.fhir.org/user_uploads/10155/BILYJerATC59WlG15J316BEf/WES_FullSequencedRegion_GRCh38.bed](https://chat.fhir.org/user_uploads/10155/BILYJerATC59WlG15J316BEf/WES_FullSequencedRegion_GRCh38.bed) | WES_FullSequencedRegion_GRCh38 | 2019-03-01 01:02:01+0100 |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "WES-FullSequencedRegion-GRCh38",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/identifiers/files",
      "value" : "11117"
    }
  ],
  "status" : "current",
  "docStatus" : "preliminary",
  "description" : "WES_FullSequencedRegion_GRCh38: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline.",
  "securityLabel" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
          "code" : "R",
          "display" : "Restricted"
        }
      ]
    }
  ],
  "content" : [
    {
      "attachment" : {
        "url" : "https://chat.fhir.org/user_uploads/10155/BILYJerATC59WlG15J316BEf/WES_FullSequencedRegion_GRCh38.bed",
        "title" : "WES_FullSequencedRegion_GRCh38",
        "creation" : "2019-03-01T01:02:01+01:00"
      }
    }
  ]
}

```
