# UncallableRegions - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **UncallableRegions**

## Example DocumentReference: UncallableRegions

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Data File](StructureDefinition-genomic-data-file.md)

**identifier**: `http://example.org/identifiers/files`/11125

**status**: Current

**docStatus**: Preliminary

**description**: 

Representing a BED file that represents uncallable regions

**securityLabel**: Restricted

> **content**

### Attachments

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Url** | **Title** | **Creation** |
| * | [https://chat.fhir.org/user_uploads/10155/jQZWWKs4JO8ZfhfrbsCbbMUA/uncallable_regions.bed](https://chat.fhir.org/user_uploads/10155/jQZWWKs4JO8ZfhfrbsCbbMUA/uncallable_regions.bed) | Uncalleable Regions | 2019-03-01 01:02:01+0100 |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "UncallableRegions",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/identifiers/files",
      "value" : "11125"
    }
  ],
  "status" : "current",
  "docStatus" : "preliminary",
  "description" : "Representing a BED file that represents uncallable regions",
  "securityLabel" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
          "code" : "R",
          "display" : "Restricted"
        }
      ]
    }
  ],
  "content" : [
    {
      "attachment" : {
        "url" : "https://chat.fhir.org/user_uploads/10155/jQZWWKs4JO8ZfhfrbsCbbMUA/uncallable_regions.bed",
        "title" : "Uncalleable Regions",
        "creation" : "2019-03-01T01:02:01+01:00"
      }
    }
  ]
}

```
