# somaticReport - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **somaticReport**

## Example DiagnosticReport: somaticReport

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## Genetic analysis report (Genetics ) 

| | |
| :--- | :--- |
| When For | 2023-02-02 |
| Performers | [Practitioner Test Dolin](Practitioner-pathologistPractitioner.md)[Organization My Test Pathology Laboratories](Organization-performingOrganization.md) |
| Identifier | Accession ID/23-0000345 |

**Report Details**

* **Code**: [Genetic variant assessment](Observation-NOTCH1-uncertain-var.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Genetic variant assessment](Observation-ZFHX3-uncertain-var.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Genetic variant assessment](Observation-MSH2-del-var.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Genetic variant assessment](Observation-NTHL1-snv-var.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Genetic variant assessment](Observation-STAG2-insertion-var.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Genetic variant assessment](Observation-ATR-insertion-var.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Genetic variant assessment](Observation-EGFR-L858R-var.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Genetic variant assessment](Observation-ROS1-Fusion-var.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Diagnostic Implication](Observation-NOTCH1-significance.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Diagnostic Implication](Observation-ZFHX3-significance.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Diagnostic Implication](Observation-MSH2-del-disease.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Diagnostic Implication](Observation-NTHL1-snv-disease.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Diagnostic Implication](Observation-STAG2-insertion-significance.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Diagnostic Implication](Observation-ATR-insertion-significance.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Diagnostic Implication](Observation-EGFR-L858R-significance.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Diagnostic Implication](Observation-ROS1-Fusion-disease.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Therapeutic Implication](Observation-ROS1-Fusion-therapuTrial.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Therapeutic Implication](Observation-ROS1-Fusion-therapuDrug.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Therapeutic Implication](Observation-EGFR-L858R-therapuDrug1.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Therapeutic Implication](Observation-EGFR-L858R-therapuDrug2.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Therapeutic Implication](Observation-TMB-therapuDrug.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Molecular Consequence](Observation-NOTCH1-uncertain-molc.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Molecular Consequence](Observation-ZFHX3-uncertain-molc.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Molecular Consequence](Observation-MSH2-del-molc.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Molecular Consequence](Observation-NTHL1-snv-molc.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Molecular Consequence](Observation-STAG2-insertion-molc.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Molecular Consequence](Observation-ATR-insertion-molc.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Molecular Consequence](Observation-EGFR-L858R-molc.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Molecular Consequence](Observation-ROS1-Fusion.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Mutations/Megabase [# Ratio] in Tumor](Observation-TMBExample.md)
  * **Value**: 29.8
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Microsatellite instability [Interpretation] in Cancer specimen Qualitative](Observation-MSIExample.md)
  * **Value**: MSI-H
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [PD-L1 by clone 22C3 in Tissue by Immune stain Report](Observation-PDL1Example.md)
  * **Value**: Positive
  * **Flags**: Final
  * **Note**: > 5% tumor proportion score
  * **When For**: 2023-02-01
  * **Reported**: 
* **Code**: [Haplotype Name](Observation-HLA-A-haplotype1.md)
  * **Value**: HLA-A*24:02
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 2023-02-01 00:00:00-0500
* **Code**: [Haplotype Name](Observation-HLA-A-haplotype2.md)
  * **Value**: HLA-A*02:06
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 2023-02-01 00:00:00-0500
* **Code**: [Haplotype Name](Observation-HLA-B-haplotype1.md)
  * **Value**: HLA-B*35:01
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 2023-02-01 00:00:00-0500
* **Code**: [Haplotype Name](Observation-HLA-B-haplotype2.md)
  * **Value**: HLA-B*35:01
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 2023-02-01 00:00:00-0500
* **Code**: [Haplotype Name](Observation-HLA-C-haplotype1.md)
  * **Value**: HLA-C*03:03
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 2023-02-01 00:00:00-0500
* **Code**: [Haplotype Name](Observation-HLA-C-haplotype2.md)
  * **Value**: HLA-C*15:02
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2023-02-01
  * **Reported**: 2023-02-01 00:00:00-0500

Patient is positive for Tier 1 / Level A variants, including variants with FDA-approved indications.

**Coded Conclusions:**

* Positive



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "somaticReport",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "ACSN",
            "display" : "Accession ID"
          }
        ]
      },
      "value" : "23-0000345"
    }
  ],
  "basedOn" : [
    {
      "reference" : "ServiceRequest/somaticServiceRequest"
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE",
          "display" : "Genetics"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "51969-4",
        "display" : "Genetic analysis report"
      }
    ]
  },
  "effectiveDateTime" : "2023-02-02",
  "performer" : [
    {
      "reference" : "Practitioner/pathologistPractitioner"
    },
    {
      "reference" : "Organization/performingOrganization"
    }
  ],
  "resultsInterpreter" : [
    {
      "reference" : "Practitioner/supervisorPractitioner"
    },
    {
      "reference" : "Organization/performingOrganization"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/NOTCH1-uncertain-var"
    },
    {
      "reference" : "Observation/ZFHX3-uncertain-var"
    },
    {
      "reference" : "Observation/MSH2-del-var"
    },
    {
      "reference" : "Observation/NTHL1-snv-var"
    },
    {
      "reference" : "Observation/STAG2-insertion-var"
    },
    {
      "reference" : "Observation/ATR-insertion-var"
    },
    {
      "reference" : "Observation/EGFR-L858R-var"
    },
    {
      "reference" : "Observation/ROS1-Fusion-var"
    },
    {
      "reference" : "Observation/NOTCH1-significance"
    },
    {
      "reference" : "Observation/ZFHX3-significance"
    },
    {
      "reference" : "Observation/MSH2-del-disease"
    },
    {
      "reference" : "Observation/NTHL1-snv-disease"
    },
    {
      "reference" : "Observation/STAG2-insertion-significance"
    },
    {
      "reference" : "Observation/ATR-insertion-significance"
    },
    {
      "reference" : "Observation/EGFR-L858R-significance"
    },
    {
      "reference" : "Observation/ROS1-Fusion-disease"
    },
    {
      "reference" : "Observation/ROS1-Fusion-therapuTrial"
    },
    {
      "reference" : "Observation/ROS1-Fusion-therapuDrug"
    },
    {
      "reference" : "Observation/EGFR-L858R-therapuDrug1"
    },
    {
      "reference" : "Observation/EGFR-L858R-therapuDrug2"
    },
    {
      "reference" : "Observation/TMB-therapuDrug"
    },
    {
      "reference" : "Observation/NOTCH1-uncertain-molc"
    },
    {
      "reference" : "Observation/ZFHX3-uncertain-molc"
    },
    {
      "reference" : "Observation/MSH2-del-molc"
    },
    {
      "reference" : "Observation/NTHL1-snv-molc"
    },
    {
      "reference" : "Observation/STAG2-insertion-molc"
    },
    {
      "reference" : "Observation/ATR-insertion-molc"
    },
    {
      "reference" : "Observation/EGFR-L858R-molc"
    },
    {
      "reference" : "Observation/ROS1-Fusion"
    },
    {
      "reference" : "Observation/TMBExample"
    },
    {
      "reference" : "Observation/MSIExample"
    },
    {
      "reference" : "Observation/PDL1Example"
    },
    {
      "reference" : "Observation/HLA-A-haplotype1"
    },
    {
      "reference" : "Observation/HLA-A-haplotype2"
    },
    {
      "reference" : "Observation/HLA-B-haplotype1"
    },
    {
      "reference" : "Observation/HLA-B-haplotype2"
    },
    {
      "reference" : "Observation/HLA-C-haplotype1"
    },
    {
      "reference" : "Observation/HLA-C-haplotype2"
    }
  ],
  "study" : [
    {
      "reference" : "GenomicStudy/somaticStudy",
      "display" : "somaticStudy"
    }
  ],
  "conclusion" : "Patient is positive for Tier 1 / Level A variants, including variants with FDA-approved indications.",
  "conclusionCode" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6576-8",
            "display" : "Positive"
          }
        ]
      }
    }
  ]
}

```
