# PGxGenomicReportEMERGE-withGrouping - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **PGxGenomicReportEMERGE-withGrouping**

## Example DiagnosticReport: PGxGenomicReportEMERGE-withGrouping

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## Genetic analysis report (Genetics ) 

| | |
| :--- | :--- |
| Subject | Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, )) |
| When For | 2020-01-01 00:00:00-0500 |
| Reported | 2020-01-01 00:00:00-0500 |
| Performer | [Organization some lab](Organization-ExampleOrg.md) |

**Report Details**

* **Code**: [Group](Observation-GrouperEx01.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2019-04-01
* **Code**: [Group](Observation-GrouperEx02.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2019-04-01
* **Code**: [Group](Observation-GrouperEx03.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2019-04-01



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "PGxGenomicReportEMERGE-withGrouping",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
      "valueReference" : {
        "reference" : "Task/PGxRecEx01",
        "display" : "No clopidogrel"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
      "valueReference" : {
        "reference" : "Task/PGxRecEx02",
        "display" : "No voriconazole"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
      "valueReference" : {
        "reference" : "Task/PGxRecEx03",
        "display" : "50% citalopram"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
      "valueReference" : {
        "reference" : "Task/PGxRecEx04",
        "display" : "50% escitalopram"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
      "valueReference" : {
        "reference" : "Task/PGxRecEx04",
        "display" : "50% amitriptyline"
      }
    }
  ],
  "basedOn" : [
    {
      "reference" : "ServiceRequest/eMERGEServiceRequest"
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "51969-4"
      },
      {
        "system" : "http://example.org/hgsc.bcm.edu/lab-test-codes/",
        "code" : "emerge-seq-ngs-pnl"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2020-01-01T00:00:00-05:00",
  "issued" : "2020-01-01T00:00:00-05:00",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/GrouperEx01",
      "display" : "Therapeutic Implications"
    },
    {
      "reference" : "Observation/GrouperEx02",
      "display" : "Genotypes"
    },
    {
      "reference" : "Observation/GrouperEx03",
      "display" : "Regions studied and Variants"
    }
  ]
}

```
