# GenomicReportExample01 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **GenomicReportExample01**

## Example DiagnosticReport: GenomicReportExample01

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## HLA-B*15:02 [Presence] (Genetics ) 

| | |
| :--- | :--- |
| Subject | Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, )) |
| When For | 2016 |
| Reported | 2018-03-06 00:00:00-0500 |
| Performer | [Organization some lab](Organization-ExampleOrg.md) |

**Report Details**

* **Code**: [Therapeutic Implication](Observation-TherapeuticImplicationExample1.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2019-04-01
* **Code**: [Genotype display name](Observation-GenotypeExample1.md)
  * **Value**: HLA-B*15:02
  * **Flags**: Final
  * **When For**: 2019-04-01

Patient is positive for high risk allele HLA-B*15:02 and should not be treated with CBZ.

**Coded Conclusions:**

* Positive



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "GenomicReportExample01",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
      "valueReference" : {
        "reference" : "Task/MedicationRecommendationExample1"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact",
      "valueRelatedArtifact" : {
        "type" : "citation",
        "document" : {
          "url" : "https://cpicpgx.org/guidelines/guideline-for-clopidogrel-and-cyp2c19"
        }
      }
    }
  ],
  "basedOn" : [
    {
      "reference" : "ServiceRequest/GenomicServiceRequestExample01"
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "51969-4"
      },
      {
        "system" : "http://loinc.org",
        "code" : "57979-7",
        "display" : "HLA-B*15:02 [Presence]"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2016",
  "issued" : "2018-03-06T00:00:00-05:00",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/TherapeuticImplicationExample1",
      "display" : "impact for high risk allele"
    },
    {
      "reference" : "Observation/GenotypeExample1"
    }
  ],
  "conclusion" : "Patient is positive for high risk allele HLA-B*15:02 and should not be treated with CBZ.",
  "conclusionCode" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6576-8",
            "display" : "Positive"
          }
        ]
      }
    }
  ]
}

```
