# Sequence Phase Relationship Codes - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Sequence Phase Relationship Codes**

## CodeSystem: Sequence Phase Relationship Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/sequence-phase-relationship-cs | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:SequencePhaseRelationshipCS |

 
Code System for specific types of relationships 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SequencePhaseRelationshipVS](ValueSet-sequence-phase-relationship-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "sequence-phase-relationship-cs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/sequence-phase-relationship-cs",
  "version" : "4.0.0-ballot",
  "name" : "SequencePhaseRelationshipCS",
  "title" : "Sequence Phase Relationship Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Code System for specific types of relationships",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 4,
  "concept" : [
    {
      "code" : "Cis",
      "display" : "Cis",
      "definition" : "Phase is in cis (same chromosome)"
    },
    {
      "code" : "Trans",
      "display" : "Trans",
      "definition" : "Phase is in trans (different chromosomes)"
    },
    {
      "code" : "Indeterminate",
      "display" : "Indeterminate",
      "definition" : "Phase is unable to be determined"
    },
    {
      "code" : "Unknown",
      "display" : "Unknown",
      "definition" : "Phase is unknown"
    }
  ]
}

```
