# Molecular Biomarker Ontology Codes - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Molecular Biomarker Ontology Codes**

## CodeSystem: Molecular Biomarker Ontology Codes (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/molecular-biomarker-ontology-cs | *Version*:4.0.0-ballot |
| *Standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) | *Computable Name*:MolecularBiomarkerOntologyCS |

 
This (experimental) code system provides for a draft categorization of biomarkers along several axes. Based on ballot feedback, the committee anticipates significant revisions. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MolecularBiomarkerCategoryVS](ValueSet-molecular-biomarker-category-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "molecular-biomarker-ontology-cs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/molecular-biomarker-ontology-cs",
  "version" : "4.0.0-ballot",
  "name" : "MolecularBiomarkerOntologyCS",
  "title" : "Molecular Biomarker Ontology Codes",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "This (experimental) code system provides for a draft categorization of biomarkers along several axes. Based on ballot feedback, the committee anticipates significant revisions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "count" : 17,
  "concept" : [
    {
      "code" : "_physiologyBiomarkerCategory",
      "display" : "Molecular biomarker physiologic role category",
      "definition" : "A category based on the normal bodily function of the biomarker.",
      "concept" : [
        {
          "code" : "antibody",
          "display" : "antibody category",
          "definition" : "Molecular biomarker physiologic role is an antibody."
        },
        {
          "code" : "antgen",
          "display" : "antigen category",
          "definition" : "Molecular biomarker physiologic role is an antigen."
        },
        {
          "code" : "cellReceptor",
          "display" : "cell receptor category",
          "definition" : "Molecular biomarker physiologic role is a cell receptor."
        },
        {
          "code" : "cellReceptorLigand",
          "display" : "cell receptor ligand category",
          "definition" : "Molecular biomarker physiologic role is a cell receptor ligand."
        }
      ]
    },
    {
      "code" : "_moleculeTypeBiomarkerCategory",
      "display" : "Molecular biomarker molecular type category",
      "definition" : "A category based on the type of biomarker molecule.",
      "concept" : [
        {
          "code" : "carbohydrate",
          "display" : "carbohydrate category",
          "definition" : "Molecular biomarker molecule type is a carbohydrate."
        },
        {
          "code" : "lipid",
          "display" : "lipid category",
          "definition" : "Molecular biomarker molecule type is a lipid."
        },
        {
          "code" : "nucleicAcid",
          "display" : "nucleic acid category",
          "definition" : "Molecular biomarker molecule type is a nucleic acid."
        },
        {
          "code" : "protein",
          "display" : "protein category",
          "definition" : "Molecular biomarker molecule type is a protein. Includes single or multi-subunit proteins with or without post-translational modifications."
        }
      ]
    },
    {
      "code" : "_methodBiomarkerCategory",
      "display" : "Molecular biomarker method type category",
      "definition" : "A category based on the measurement ascertainment method of the biomarker. (Methods are drawn from LOINC (https://loinc.org/kb/users-guide/major-parts-of-a-loinc-term/#type-of-method-6th-part) and NCBI Genetic Testing Registry (https://www.ncbi.nlm.nih.gov/gtr/)).",
      "concept" : [
        {
          "code" : "enzymeAssay",
          "display" : "enzyme assay category",
          "definition" : "Molecular biomarker method is enzyme assay."
        },
        {
          "code" : "flowCytometry",
          "display" : "flow cytometry category",
          "definition" : "Molecular biomarker method is flow cytometry."
        },
        {
          "code" : "immuneStain",
          "display" : "immune stain category",
          "definition" : "Molecular biomarker method is immune stain."
        },
        {
          "code" : "immunoassay",
          "display" : "immunoassay category",
          "definition" : "Molecular biomarker method is immunoassay."
        },
        {
          "code" : "methylationAnalysis",
          "display" : "methylation analysis category",
          "definition" : "Molecular biomarker method is methylation analysis."
        },
        {
          "code" : "molgen",
          "display" : "molecular sequence adjacent category",
          "definition" : "Molecular biomarker method is molecular sequence adjacent observation."
        }
      ]
    }
  ]
}

```
